/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local;

import java.io.IOException;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class LocalGatewayMetaState {
    private final long version;
    private final MetaData metaData;

    public LocalGatewayMetaState(long version, MetaData metaData) {
        this.version = version;
        this.metaData = metaData;
    }

    public long version() {
        return this.version;
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long version;
        private MetaData metaData;

        public Builder state(LocalGatewayMetaState state) {
            this.version = state.version();
            this.metaData = state.metaData();
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder metaData(MetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public LocalGatewayMetaState build() {
            return new LocalGatewayMetaState(this.version, this.metaData);
        }

        public static void toXContent(LocalGatewayMetaState state, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("state");
            builder.field("version", state.version());
            MetaData.Builder.toXContent(state.metaData(), builder, params);
            builder.endObject();
        }

        public static LocalGatewayMetaState fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                return builder.build();
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (!"meta-data".equals(currentFieldName)) continue;
                    builder.metaData = MetaData.Builder.fromXContent(parser);
                    continue;
                }
                if (!token.isValue() || !"version".equals(currentFieldName)) continue;
                builder.version = parser.longValue();
            }
            return builder.build();
        }

        public static LocalGatewayMetaState readFrom(StreamInput in) throws IOException {
            Builder builder = new Builder();
            builder.version = in.readLong();
            builder.metaData = MetaData.Builder.readFrom(in);
            return builder.build();
        }

        public static void writeTo(LocalGatewayMetaState state, StreamOutput out) throws IOException {
            out.writeLong(state.version());
            MetaData.Builder.writeTo(state.metaData(), out);
        }
    }
}

