/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.trove.map.hash.TIntObjectHashMap;

public class HandlesStreamInput
extends StreamInput {
    private StreamInput in;
    private final TIntObjectHashMap<String> handles = new TIntObjectHashMap();
    private final TIntObjectHashMap<String> identityHandles = new TIntObjectHashMap();

    HandlesStreamInput() {
    }

    public HandlesStreamInput(StreamInput in) {
        this.in = in;
    }

    @Override
    public String readUTF() throws IOException {
        byte b = this.in.readByte();
        if (b == 0) {
            int handle = this.in.readVInt();
            String s = this.in.readUTF();
            this.handles.put(handle, s);
            return s;
        }
        if (b == 1) {
            return this.handles.get(this.in.readVInt());
        }
        if (b == 2) {
            int handle = this.in.readVInt();
            String s = this.in.readUTF();
            this.identityHandles.put(handle, s);
            return s;
        }
        if (b == 3) {
            return this.identityHandles.get(this.in.readVInt());
        }
        throw new IOException("Expected handle header, got [" + b + "]");
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.in.readBytes(b, offset, len);
    }

    public void cleanHandles() {
        this.handles.clear();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.handles.clear();
    }

    public void reset(StreamInput in) {
        this.in = in;
        this.handles.clear();
        this.identityHandles.clear();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

