/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import org.elasticsearch.common.annotations.Beta;
import org.elasticsearch.common.base.Preconditions;

@Beta
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    public boolean accept(File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

