/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.List;
import org.elasticsearch.cluster.routing.allocation.ClusterRebalanceNodeAllocation;
import org.elasticsearch.cluster.routing.allocation.ConcurrentRebalanceNodeAllocation;
import org.elasticsearch.cluster.routing.allocation.NodeAllocation;
import org.elasticsearch.cluster.routing.allocation.NodeAllocations;
import org.elasticsearch.cluster.routing.allocation.RebalanceOnlyWhenActiveNodeAllocation;
import org.elasticsearch.cluster.routing.allocation.ReplicaAfterPrimaryActiveNodeAllocation;
import org.elasticsearch.cluster.routing.allocation.SameShardNodeAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardsAllocation;
import org.elasticsearch.cluster.routing.allocation.ThrottlingNodeAllocation;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;

public class ShardAllocationModule
extends AbstractModule {
    private List<Class<? extends NodeAllocation>> allocations = Lists.newArrayList();

    public ShardAllocationModule(Settings settings) {
    }

    public void addNodeAllocation(Class<? extends NodeAllocation> nodeAllocation) {
        this.allocations.add(nodeAllocation);
    }

    @Override
    protected void configure() {
        this.bind(ShardsAllocation.class).asEagerSingleton();
        Multibinder<NodeAllocation> allocationMultibinder = Multibinder.newSetBinder(this.binder(), NodeAllocation.class);
        allocationMultibinder.addBinding().to(SameShardNodeAllocation.class);
        allocationMultibinder.addBinding().to(ReplicaAfterPrimaryActiveNodeAllocation.class);
        allocationMultibinder.addBinding().to(ThrottlingNodeAllocation.class);
        allocationMultibinder.addBinding().to(RebalanceOnlyWhenActiveNodeAllocation.class);
        allocationMultibinder.addBinding().to(ClusterRebalanceNodeAllocation.class);
        allocationMultibinder.addBinding().to(ConcurrentRebalanceNodeAllocation.class);
        for (Class<? extends NodeAllocation> allocation : this.allocations) {
            allocationMultibinder.addBinding().to(allocation);
        }
        this.bind(NodeAllocations.class).asEagerSingleton();
    }
}

