/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.support.replication.IndexReplicationOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;

public class IndexDeleteByQueryRequest
extends IndexReplicationOperationRequest {
    private byte[] querySource;
    private String queryParserName;
    private String[] types = Strings.EMPTY_ARRAY;
    @Nullable
    private String routing;

    IndexDeleteByQueryRequest(DeleteByQueryRequest request, String index) {
        this.index = index;
        this.timeout = request.timeout();
        this.querySource = request.querySource();
        this.queryParserName = request.queryParserName();
        this.types = request.types();
        this.replicationType = request.replicationType();
        this.consistencyLevel = request.consistencyLevel();
        this.routing = request.routing();
    }

    IndexDeleteByQueryRequest() {
    }

    byte[] querySource() {
        return this.querySource;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.querySource == null) {
            validationException = Actions.addValidationError("querySource is missing", validationException);
        }
        return validationException;
    }

    @Required
    public IndexDeleteByQueryRequest querySource(QueryBuilder queryBuilder) {
        return this.querySource(queryBuilder.buildAsBytes());
    }

    @Required
    public IndexDeleteByQueryRequest querySource(byte[] querySource) {
        this.querySource = querySource;
        return this;
    }

    String queryParserName() {
        return this.queryParserName;
    }

    String routing() {
        return this.routing;
    }

    String[] types() {
        return this.types;
    }

    public IndexDeleteByQueryRequest queryParserName(String queryParserName) {
        this.queryParserName = queryParserName;
        return this;
    }

    public IndexDeleteByQueryRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int typesSize;
        super.readFrom(in);
        this.querySource = new byte[in.readVInt()];
        in.readFully(this.querySource);
        if (in.readBoolean()) {
            this.queryParserName = in.readUTF();
        }
        if ((typesSize = in.readVInt()) > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readUTF();
            }
        }
        if (in.readBoolean()) {
            this.routing = in.readUTF();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.querySource.length);
        out.writeBytes(this.querySource);
        if (this.queryParserName == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.queryParserName);
        }
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
        if (this.routing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.routing);
        }
    }
}

