/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete.index;

import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.action.delete.index.ShardDeleteRequest;
import org.elasticsearch.action.delete.index.ShardDeleteResponse;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardDeleteAction
extends TransportShardReplicationOperationAction<ShardDeleteRequest, ShardDeleteResponse> {
    @Inject
    public TransportShardDeleteAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
        super(settings, transportService, clusterService, indicesService, threadPool, shardStateAction);
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected ShardDeleteRequest newRequestInstance() {
        return new ShardDeleteRequest();
    }

    @Override
    protected ShardDeleteResponse newResponseInstance() {
        return new ShardDeleteResponse();
    }

    @Override
    protected String transportAction() {
        return "indices/index/b_shard/delete";
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected void checkBlock(ShardDeleteRequest request, ClusterState state) {
        state.blocks().indexBlockedRaiseException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<ShardDeleteResponse> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.ShardOperationRequest shardRequest) {
        ShardDeleteRequest request = (ShardDeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indexShard(shardRequest);
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version()).origin(Engine.Operation.Origin.PRIMARY);
        indexShard.delete(delete);
        request.version(delete.version());
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ShardDeleteResponse response = new ShardDeleteResponse(delete.version(), delete.notFound());
        return new TransportShardReplicationOperationAction.PrimaryResponse<ShardDeleteResponse>(response, null);
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ShardOperationRequest shardRequest) {
        ShardDeleteRequest request = (ShardDeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indexShard(shardRequest);
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version()).origin(Engine.Operation.Origin.REPLICA);
        indexShard.delete(delete);
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, ShardDeleteRequest request) {
        GroupShardsIterator group = this.clusterService.operationRouting().broadcastDeleteShards(this.clusterService.state(), request.index());
        for (ShardIterator shardIt : group) {
            if (shardIt.shardId().id() != request.shardId()) continue;
            return shardIt;
        }
        throw new ElasticSearchIllegalStateException("No shards iterator found for shard [" + request.shardId() + "]");
    }
}

