/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class ColumnInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String internalName;
    private String alias = null;
    private String tabAlias;
    private boolean isVirtualCol;
    private transient TypeInfo type;
    private boolean isHiddenVirtualCol;

    public ColumnInfo() {
    }

    public ColumnInfo(String internalName, TypeInfo type, String tabAlias, boolean isVirtualCol) {
        this(internalName, type, tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, Class type, String tabAlias, boolean isVirtualCol) {
        this(internalName, TypeInfoFactory.getPrimitiveTypeInfoFromPrimitiveWritable(type), tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, TypeInfo type, String tabAlias, boolean isVirtualCol, boolean isHiddenVirtualCol) {
        this.internalName = internalName;
        this.type = type;
        this.tabAlias = tabAlias;
        this.isVirtualCol = isVirtualCol;
        this.isHiddenVirtualCol = isHiddenVirtualCol;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setType(TypeInfo type) {
        this.type = type;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public String getTabAlias() {
        return this.tabAlias;
    }

    public boolean getIsVirtualCol() {
        return this.isVirtualCol;
    }

    public boolean isHiddenVirtualCol() {
        return this.isHiddenVirtualCol;
    }

    public String toString() {
        return this.internalName + ": " + this.type;
    }

    public void setAlias(String col_alias) {
        this.alias = col_alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setTabAlias(String tabAlias) {
        this.tabAlias = tabAlias;
    }

    public void setVirtualCol(boolean isVirtualCol) {
        this.isVirtualCol = isVirtualCol;
    }

    public void setHiddenVirtualCol(boolean isHiddenVirtualCol) {
        this.isHiddenVirtualCol = isHiddenVirtualCol;
    }
}

