/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Permission;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PermissionMainPanel;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;

class PermissionAction
implements VAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean enabled_ = true;
    private IFSFile file_;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public PermissionAction(IFSFile iFSFile) {
        this.file_ = iFSFile;
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    Permission getPermission() {
        try {
            return new Permission(this.file_);
        }
        catch (Exception exception) {
            Trace.log(2, "construct Permission : " + exception);
            this.errorEventSupport_.fireError(exception);
            return null;
        }
    }

    public String getText() {
        return ResourceLoader.getText("OBJECT_PERMISSION2");
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void perform(VActionContext vActionContext) {
        this.workingEventSupport_.fireStartWorking();
        PermissionMainPanel permissionMainPanel = new PermissionMainPanel(this.getPermission());
        permissionMainPanel.addErrorListener(this.errorEventSupport_);
        permissionMainPanel.addWorkingListener(this.workingEventSupport_);
        permissionMainPanel.addVObjectListener(this.objectEventSupport_);
        permissionMainPanel.createPermissionMainPanel();
        this.workingEventSupport_.fireStopWorking();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setEnabled(boolean bl) {
        this.enabled_ = bl;
    }
}

