/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RCCallProgramFailureReplyDataStream;
import com.ibm.as400.access.RCCallProgramReplyDataStream;
import com.ibm.as400.access.RCCallProgramRequestDataStream;
import com.ibm.as400.access.RCExchangeAttributesReplyDataStream;
import com.ibm.as400.access.RCExchangeAttributesRequestDataStream;
import com.ibm.as400.access.RCRunCommandReplyDataStream;
import com.ibm.as400.access.RCRunCommandRequestDataStream;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class RemoteCommandImplRemote
implements RemoteCommandImpl {
    AS400ImplRemote system_;
    ConverterImplRemote converter_;
    ConverterImplRemote unicodeConverter_;
    boolean ccsidIsUserOveride_ = false;
    private AS400Server server_;
    AS400Message[] messageList_ = new AS400Message[0];
    int serverDataStreamLevel_ = 0;

    RemoteCommandImplRemote() {
    }

    public void setSystem(AS400Impl aS400Impl) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting up remote command implementation object.");
        }
        this.system_ = (AS400ImplRemote)aS400Impl;
        int n = this.system_.getUserOverrideCcsid();
        if (n != 0) {
            this.converter_ = ConverterImplRemote.getConverter(n, this.system_);
            this.ccsidIsUserOveride_ = true;
        }
    }

    public String getJobInfo(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job information from implementation object.");
        }
        this.open(bl);
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        byte[] byArray = new byte[46];
        programParameterArray[0] = new ProgramParameter(byArray.length);
        byte[] byArray2 = BinaryConverter.intToByteArray(byArray.length);
        programParameterArray[1] = new ProgramParameter(byArray2);
        byte[] byArray3 = new byte[]{-39, -29, -27, -61, -16, -15, -16, -16};
        programParameterArray[2] = new ProgramParameter(byArray3);
        byte[] byArray4 = BinaryConverter.intToByteArray(1);
        programParameterArray[3] = new ProgramParameter(byArray4);
        byte[] byArray5 = BinaryConverter.intToByteArray(1009);
        programParameterArray[4] = new ProgramParameter(byArray5);
        programParameterArray[5] = new ProgramParameter(new byte[8]);
        try {
            if (!this.runProgram("QSYS", "QWCRTVCA", programParameterArray, bl, 0)) {
                Trace.log(2, "Unable to retrieve job information.");
                throw new AS400Exception(this.messageList_);
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            Trace.log(2, "Unexpected ObjectDoesNotExistException:", (Throwable)objectDoesNotExistException);
            throw new InternalErrorException(10);
        }
        byArray = programParameterArray[0].getOutputData();
        if (Trace.traceOn_) {
            Trace.log(1, "Job information retrieved:", byArray);
        }
        return this.converter_.byteArrayToString(byArray, 20, 26);
    }

    public AS400Message[] getMessageList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message list from implementation object.");
        }
        return this.messageList_;
    }

    public boolean isCommandThreadSafe(String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Remote implementation object returns false for command thread safety.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Remote implementation object open.");
        }
        AS400Server aS400Server = this.server_ = this.system_.getConnection(2, false);
        synchronized (aS400Server) {
            DataStream dataStream = this.server_.getExchangeAttrReply();
            if (dataStream == null) {
                try {
                    dataStream = this.server_.sendExchangeAttrRequest(new RCExchangeAttributesRequestDataStream(this.system_.getNLV()));
                }
                catch (IOException iOException) {
                    this.system_.disconnectServer(this.server_);
                    Trace.log(2, "IOException during exchange attributes:", (Throwable)iOException);
                    throw iOException;
                }
                if (!(dataStream instanceof RCExchangeAttributesReplyDataStream)) {
                    Trace.log(2, "Unknown exchange attributes reply datastream:", dataStream.data_);
                    this.system_.disconnectServer(this.server_);
                    throw new InternalErrorException(2);
                }
                this.processReturnCode(((RCExchangeAttributesReplyDataStream)dataStream).getRC());
            }
            RCExchangeAttributesReplyDataStream rCExchangeAttributesReplyDataStream = (RCExchangeAttributesReplyDataStream)dataStream;
            if (!this.ccsidIsUserOveride_) {
                this.converter_ = ConverterImplRemote.getConverter(rCExchangeAttributesReplyDataStream.getCCSID(), this.system_);
            }
            this.serverDataStreamLevel_ = rCExchangeAttributesReplyDataStream.getDSLevel();
            if (this.serverDataStreamLevel_ >= 10) {
                this.unicodeConverter_ = ConverterImplRemote.getConverter(1200, this.system_);
            }
        }
    }

    public boolean runCommand(String string, boolean bl, int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running command: " + string);
        }
        this.open(bl);
        if (this.serverDataStreamLevel_ >= 10) {
            return this.runCommand(this.unicodeConverter_.stringToByteArray(string), n, 1200);
        }
        return this.runCommand(this.converter_.stringToByteArray(string), n, 0);
    }

    public boolean runCommand(byte[] byArray, boolean bl, int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running command:", byArray);
        }
        this.open(bl);
        return this.runCommand(byArray, n, 0);
    }

    private boolean runCommand(byte[] byArray, int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        try {
            DataStream dataStream = this.server_.sendAndReceive(new RCRunCommandRequestDataStream(byArray, this.serverDataStreamLevel_, n, n2));
            if (!(dataStream instanceof RCRunCommandReplyDataStream)) {
                Trace.log(2, "Unknown run command reply datastream:", dataStream.data_);
                this.system_.disconnectServer(this.server_);
                throw new InternalErrorException(2);
            }
            RCRunCommandReplyDataStream rCRunCommandReplyDataStream = (RCRunCommandReplyDataStream)dataStream;
            this.messageList_ = rCRunCommandReplyDataStream.getMessageList(this.converter_);
            int n3 = rCRunCommandReplyDataStream.getRC();
            this.processReturnCode(n3);
            return n3 == 0;
        }
        catch (IOException iOException) {
            this.system_.disconnectServer(this.server_);
            Trace.log(2, "Lost connection to remote command server:", (Throwable)iOException);
            throw iOException;
        }
    }

    public boolean runProgram(String string, String string2, ProgramParameter[] programParameterArray, boolean bl, int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running program: " + string + "/" + string2);
        }
        this.open(bl);
        try {
            String string3;
            DataStream dataStream = this.server_.sendAndReceive(new RCCallProgramRequestDataStream(string, string2, programParameterArray, this.converter_, this.serverDataStreamLevel_, n));
            if (!(dataStream instanceof RCCallProgramReplyDataStream)) {
                Trace.log(2, "Unknown run program reply datastream ", dataStream.data_);
                this.system_.disconnectServer(this.server_);
                throw new InternalErrorException(2);
            }
            RCCallProgramReplyDataStream rCCallProgramReplyDataStream = (RCCallProgramReplyDataStream)dataStream;
            int n2 = rCCallProgramReplyDataStream.getRC();
            this.processReturnCode(n2);
            if (n2 == 0) {
                rCCallProgramReplyDataStream.getParameterList(programParameterArray);
                this.messageList_ = new AS400Message[0];
                return true;
            }
            this.messageList_ = rCCallProgramReplyDataStream.getMessageList(this.converter_);
            if (n2 == 1280 && this.messageList_.length != 0 && (string3 = this.messageList_[this.messageList_.length - 1].getID()).equals("MCH3401")) {
                byte[] byArray = this.messageList_[this.messageList_.length - 1].getSubstitutionData();
                if (byArray[0] == 2 && byArray[1] == 1 && string2.equals(this.converter_.byteArrayToString(byArray, 2, 30).trim())) {
                    throw new ObjectDoesNotExistException(QSYSObjectPathName.toPath(string, string2, "PGM"), 2);
                }
                if (byArray[0] == 4 && byArray[1] == 1 && string.equals(this.converter_.byteArrayToString(byArray, 2, 30).trim())) {
                    throw new ObjectDoesNotExistException(QSYSObjectPathName.toPath(string, string2, "PGM"), 1);
                }
            }
            return false;
        }
        catch (IOException iOException) {
            this.system_.disconnectServer(this.server_);
            Trace.log(2, "Lost connection to remote command server:", (Throwable)iOException);
            throw iOException;
        }
    }

    public byte[] runServiceProgram(String string, String string2, String string3, int n, ProgramParameter[] programParameterArray, boolean bl, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running service program: " + string + "/" + string2 + " procedure name: " + string3);
        }
        this.open(bl);
        ProgramParameter[] programParameterArray2 = new ProgramParameter[7 + programParameterArray.length];
        byte[] byArray = new byte[20];
        for (int i = 0; i < 20; ++i) {
            byArray[i] = 64;
        }
        this.converter_.stringToByteArray(string2, byArray, 0);
        this.converter_.stringToByteArray(string, byArray, 10);
        programParameterArray2[0] = new ProgramParameter(byArray);
        ConverterImplRemote converterImplRemote = ConverterImplRemote.getConverter(n2, this.system_);
        byte[] byArray2 = converterImplRemote.stringToByteArray(string3);
        byte[] byArray3 = new byte[byArray2.length + 1];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        programParameterArray2[1] = new ProgramParameter(byArray3);
        byte[] byArray4 = new byte[4];
        BinaryConverter.intToByteArray(n, byArray4, 0);
        programParameterArray2[2] = new ProgramParameter(byArray4);
        byte[] byArray5 = new byte[programParameterArray.length * 4];
        for (int i = 0; i < programParameterArray.length; ++i) {
            int n4 = programParameterArray[i].getParameterType();
            if (this.serverDataStreamLevel_ < 6 && programParameterArray[i].getUsage() == 255) {
                n4 = 1;
            }
            BinaryConverter.intToByteArray(n4, byArray5, i * 4);
        }
        programParameterArray2[3] = new ProgramParameter(byArray5);
        byte[] byArray6 = new byte[4];
        BinaryConverter.intToByteArray(programParameterArray.length, byArray6, 0);
        programParameterArray2[4] = new ProgramParameter(byArray6);
        programParameterArray2[5] = new ProgramParameter(new byte[8]);
        programParameterArray2[6] = new ProgramParameter(n == 0 ? 4 : 8);
        System.arraycopy(programParameterArray, 0, programParameterArray2, 7, programParameterArray.length);
        if (!this.runProgram("QSYS", "QZRUCLSP", programParameterArray2, bl, n3)) {
            return null;
        }
        return programParameterArray2[6].getOutputData();
    }

    private void processReturnCode(int n) throws ErrorCompletingRequestException {
        if (Trace.traceOn_) {
            byte[] byArray = new byte[2];
            BinaryConverter.unsignedShortToByteArray(n, byArray, 0);
            Trace.log(1, "Remote command server return code:", byArray);
        }
        switch (n) {
            case 0: {
                if (Trace.traceOn_) {
                    Trace.log(3, "Request processed successfully.");
                }
                return;
            }
            case 256: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Limited user.");
                }
                return;
            }
            case 257: {
                Trace.log(2, "Exchange attributes request not valid.");
                this.system_.disconnectServer(this.server_);
                throw new InternalErrorException(5);
            }
            case 258: {
                Trace.log(2, "Datastream level not valid.");
                this.system_.disconnectServer(this.server_);
                throw new InternalErrorException(1);
            }
            case 259: {
                Trace.log(2, "Version not valid.");
                this.system_.disconnectServer(this.server_);
                throw new InternalErrorException(7);
            }
            case 260: {
                if (Trace.traceOn_) {
                    Trace.log(4, "CCSID not valid.");
                }
                return;
            }
            case 261: {
                if (Trace.traceOn_) {
                    Trace.log(4, "NLV not valid");
                }
                return;
            }
            case 262: {
                if (Trace.traceOn_) {
                    Trace.log(4, "NLV not installed.");
                }
                return;
            }
            case 263: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Error retrieving product information, cannot validate NLV.");
                }
                return;
            }
            case 264: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Error adding NLV library to system library list.");
                }
                return;
            }
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 517: {
                Trace.log(2, "Datastream not valid.");
                this.system_.disconnectServer(this.server_);
                throw new InternalErrorException(5);
            }
            case 516: {
                Trace.log(2, "Host Resource error.");
                this.system_.disconnectServer(this.server_);
                throw new ErrorCompletingRequestException(1);
            }
            case 768: {
                Trace.log(2, "Process exit point error.");
                this.system_.disconnectServer(this.server_);
                throw new ErrorCompletingRequestException(2);
            }
            case 769: 
            case 770: {
                Trace.log(2, "Request not valid.");
                this.system_.disconnectServer(this.server_);
                throw new InternalErrorException(5);
            }
            case 771: {
                Trace.log(2, "Maximum exceeded.");
                throw new ErrorCompletingRequestException(9);
            }
            case 772: {
                Trace.log(2, "Error calling exit program.");
                this.system_.disconnectServer(this.server_);
                throw new ErrorCompletingRequestException(3);
            }
            case 773: {
                Trace.log(2, "Exit program denied request.");
                this.system_.disconnectServer(this.server_);
                throw new ErrorCompletingRequestException(4);
            }
            case 1024: {
                if (Trace.traceOn_) {
                    Trace.log(3, "Error calling the command.");
                }
                return;
            }
            case 1025: {
                Trace.log(2, "CCSID not valid.");
                throw new InternalErrorException(5);
            }
            case 1280: {
                if (Trace.traceOn_) {
                    Trace.log(2, "Could not resolve program.");
                }
                return;
            }
            case 1281: {
                if (Trace.traceOn_) {
                    Trace.log(1, "Error calling the program.");
                }
                return;
            }
        }
        Trace.log(2, "Return code unknown.");
        this.system_.disconnectServer(this.server_);
        throw new InternalErrorException(9);
    }

    static AS400Message[] parseMessages(byte[] byArray, ConverterImplRemote converterImplRemote) throws IOException {
        int n = BinaryConverter.byteArrayToUnsignedShort(byArray, 22);
        AS400Message[] aS400MessageArray = new AS400Message[n];
        int n2 = 24;
        for (int i = 0; i < n; ++i) {
            if (byArray[n2 + 5] == 6) {
                aS400MessageArray[i] = AS400ImplRemote.parseMessage(byArray, n2 + 6, converterImplRemote);
            } else {
                aS400MessageArray[i] = new AS400Message();
                aS400MessageArray[i].setID(converterImplRemote.byteArrayToString(byArray, n2 + 6, 7));
                aS400MessageArray[i].setType((byArray[n2 + 13] & 0xF) * 10 + (byArray[n2 + 14] & 0xF));
                aS400MessageArray[i].setSeverity(BinaryConverter.byteArrayToUnsignedShort(byArray, n2 + 15));
                aS400MessageArray[i].setFileName(converterImplRemote.byteArrayToString(byArray, n2 + 17, 10).trim());
                aS400MessageArray[i].setLibraryName(converterImplRemote.byteArrayToString(byArray, n2 + 27, 10).trim());
                int n3 = BinaryConverter.byteArrayToUnsignedShort(byArray, n2 + 37);
                int n4 = BinaryConverter.byteArrayToUnsignedShort(byArray, n2 + 39);
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2 + 41, byArray2, 0, n3);
                aS400MessageArray[i].setSubstitutionData(byArray2);
                aS400MessageArray[i].setText(converterImplRemote.byteArrayToString(byArray, n2 + 41 + n3, n4));
            }
            n2 += BinaryConverter.byteArrayToInt(byArray, n2);
        }
        return aS400MessageArray;
    }

    static {
        AS400Server.addReplyStream((DataStream)new RCExchangeAttributesReplyDataStream(), 2);
        AS400Server.addReplyStream((DataStream)new RCRunCommandReplyDataStream(), 2);
        AS400Server.addReplyStream((DataStream)new RCCallProgramReplyDataStream(), 2);
        AS400Server.addReplyStream((DataStream)new RCCallProgramFailureReplyDataStream(), 2);
    }
}

