/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ProxyException;
import com.ibm.as400.access.PxAcceptRepCV;
import com.ibm.as400.access.PxClientReadDaemon;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxRepCV;
import com.ibm.as400.access.PxReqCV;
import com.ibm.as400.access.PxSecureSocketContainer;
import com.ibm.as400.access.PxSocketContainer;
import com.ibm.as400.access.PxSocketContainerAdapter;
import com.ibm.as400.access.RetryInputStream;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;

abstract class PxClientConnectionAdapter {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean closed_ = false;
    private InputStream input_ = null;
    private OutputStream output_ = null;
    private PxClientReadDaemon readDaemon_ = null;
    private PxSocketContainerAdapter socket_ = null;
    private SSLOptions sslOptions_ = null;
    boolean tunnel_ = false;
    private long clientId_ = -1L;
    private URL tunnelURL_ = null;

    protected PxClientConnectionAdapter(String string, SSLOptions sSLOptions) {
        this.sslOptions_ = sSLOptions;
        this.open(string);
    }

    public void close() {
        if (!this.tunnel_) {
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, "Closing a connection to proxy server.");
            }
            this.readDaemon_.stopSafely();
            try {
                this.input_.close();
            }
            catch (IOException iOException) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, iOException.getMessage(), (Throwable)iOException);
                }
                throw new ProxyException(2);
            }
            try {
                this.output_.close();
            }
            catch (IOException iOException) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, iOException.getMessage(), (Throwable)iOException);
                }
                throw new ProxyException(2);
            }
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, iOException.getMessage(), (Throwable)iOException);
                }
                throw new ProxyException(2);
            }
        }
        this.closed_ = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed_) {
            this.close();
        }
        super.finalize();
    }

    public PxDSFactory getFactory() {
        return this.readDaemon_.getFactory();
    }

    public void open(String string) {
        int n;
        boolean bl;
        boolean bl2 = bl = this.sslOptions_ != null && this.sslOptions_.proxyEncryptionMode_ != 2;
        if (Trace.isTraceOn()) {
            Trace.log(6, "Opening a connection to proxy server " + string + " (secure=" + bl + ").");
        }
        String string2 = string;
        String string3 = null;
        int n2 = -1;
        if (string.indexOf("://") > 0) {
            this.tunnel_ = true;
            string2 = string.substring(string.indexOf(":") + 3);
            string3 = string.substring(0, string.indexOf(":"));
        }
        if ((n = string2.indexOf(58)) >= 0) {
            if (n < string2.length() - 1) {
                n2 = Integer.parseInt(string2.substring(n + 1));
            }
            string2 = string2.substring(0, n);
        }
        if (!this.tunnel_) {
            if (n2 < 0) {
                n2 = bl ? 3471 : 3470;
            }
            this.openTraditional(string2, n2, bl);
        } else {
            this.openTunnel(string3, string2, n2);
        }
    }

    void openTraditional(String string, int n, boolean bl) {
        try {
            this.socket_ = bl ? new PxSecureSocketContainer(string, n, this.sslOptions_) : new PxSocketContainer(string, n);
            this.output_ = new BufferedOutputStream(this.socket_.getOutputStream());
            this.input_ = new BufferedInputStream(new RetryInputStream(this.socket_.getInputStream()));
            this.readDaemon_ = new PxClientReadDaemon(this.input_);
            this.readDaemon_.start();
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, "Connection established.");
            }
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Error when opening connection to proxy server (openio", (Throwable)iOException);
            }
            throw new ProxyException(1);
        }
    }

    void openTunnel(String string, String string2, int n) {
        try {
            this.readDaemon_ = new PxClientReadDaemon();
            this.readDaemon_.register(new PxAcceptRepCV());
            this.tunnelURL_ = n < 0 ? new URL(string, string2, "/servlet/com.ibm.as400.access.TunnelProxyServer") : new URL(string, string2, n, "/servlet/com.ibm.as400.access.TunnelProxyServer");
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Error when opening connection to proxy server", (Throwable)iOException);
            }
            throw new ProxyException(1);
        }
    }

    private URLConnection tunnelSend(PxReqCV pxReqCV) {
        try {
            pxReqCV.setClientId(this.clientId_);
            URLConnection uRLConnection = this.tunnelURL_.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setDoOutput(true);
            uRLConnection.setDoInput(true);
            uRLConnection.setRequestProperty("Content-type", "application/octet-stream");
            uRLConnection.setRequestProperty("Connection", "Keep-Alive");
            OutputStream outputStream = uRLConnection.getOutputStream();
            if (Trace.isTraceProxyOn()) {
                pxReqCV.dump(Trace.getPrintWriter());
            }
            pxReqCV.writeTo(outputStream);
            outputStream.flush();
            return uRLConnection;
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Error when opening connection to proxy server", (Throwable)exception);
            }
            throw new ProxyException(1);
        }
    }

    Object tunnelReceive(long l, URLConnection uRLConnection) throws InvocationTargetException {
        try {
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                PxRepCV pxRepCV = this.readDaemon_.getReply(l, inputStream);
                Object object = pxRepCV.process();
                this.clientId_ = pxRepCV.getClientId();
                return object;
            }
            catch (IOException iOException) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, "Error when receiving reply from proxy server", (Throwable)iOException);
                }
                throw new ProxyException(2);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Error when opening connection to proxy server", (Throwable)exception);
            }
            throw new ProxyException(1);
        }
    }

    private Object receive(long l) throws InvocationTargetException {
        Object object = null;
        try {
            PxRepCV pxRepCV = this.readDaemon_.getReply(l);
            object = pxRepCV.process();
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Error when receiving reply from proxy server", (Throwable)iOException);
            }
            throw new ProxyException(2);
        }
        return object;
    }

    protected synchronized void send(PxReqCV pxReqCV) {
        if (!this.tunnel_) {
            if (Trace.isTraceProxyOn()) {
                pxReqCV.dump(Trace.getPrintWriter());
            }
            try {
                pxReqCV.writeTo(this.output_);
                this.output_.flush();
            }
            catch (IOException iOException) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, iOException.getMessage(), (Throwable)iOException);
                }
                throw new ProxyException(2);
            }
        } else {
            URLConnection uRLConnection = this.tunnelSend(pxReqCV);
        }
    }

    protected Object sendAndReceive(PxReqCV pxReqCV) throws InvocationTargetException {
        if (!this.tunnel_) {
            this.send(pxReqCV);
            return this.receive(pxReqCV.getCorrelationId());
        }
        URLConnection uRLConnection = this.tunnelSend(pxReqCV);
        Object object = this.tunnelReceive(pxReqCV.getCorrelationId(), uRLConnection);
        return object;
    }
}

