/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;

public class DecompressorStream
extends CompressionInputStream {
    protected Decompressor decompressor = null;
    protected byte[] buffer;
    protected boolean eof = false;
    protected boolean closed = false;
    private byte[] oneByte = new byte[1];
    private byte[] skipBytes = new byte[512];

    public DecompressorStream(InputStream in, Decompressor decompressor, int bufferSize) {
        super(in);
        if (in == null || decompressor == null) {
            throw new NullPointerException();
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Illegal bufferSize");
        }
        this.decompressor = decompressor;
        this.buffer = new byte[bufferSize];
    }

    public DecompressorStream(InputStream in, Decompressor decompressor) {
        this(in, decompressor, 512);
    }

    protected DecompressorStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        this.checkStream();
        return this.read(this.oneByte, 0, this.oneByte.length) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.decompress(b, off, len);
    }

    protected int decompress(byte[] b, int off, int len) throws IOException {
        int n = 0;
        while ((n = this.decompressor.decompress(b, off, len)) == 0) {
            if (this.decompressor.finished() || this.decompressor.needsDictionary()) {
                this.eof = true;
                return -1;
            }
            if (!this.decompressor.needsInput()) continue;
            this.getCompressedData();
        }
        return n;
    }

    protected void getCompressedData() throws IOException {
        this.checkStream();
        int n = this.in.read(this.buffer, 0, this.buffer.length);
        if (n == -1) {
            throw new EOFException("Unexpected end of input stream");
        }
        this.decompressor.setInput(this.buffer, 0, n);
    }

    protected void checkStream() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void resetState() throws IOException {
        this.decompressor.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.checkStream();
        int skipped = 0;
        while ((long)skipped < n) {
            int len = Math.min((int)n - skipped, this.skipBytes.length);
            if ((len = this.read(this.skipBytes, 0, len)) == -1) {
                this.eof = true;
                break;
            }
            skipped += len;
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        this.checkStream();
        return this.eof ? 0 : 1;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.in.close();
            this.closed = true;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

