/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.views;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.views.View;
import pt.webdetails.cpf.persistence.Filter;
import pt.webdetails.cpf.persistence.IPersistenceEngine;
import pt.webdetails.cpf.persistence.ISimplePersistence;
import pt.webdetails.cpf.persistence.Persistable;
import pt.webdetails.cpf.persistence.PersistenceEngine;
import pt.webdetails.cpf.persistence.SimplePersistence;

public class ViewsEngine {
    private static final Log logger = LogFactory.getLog(ViewsEngine.class);
    private static final String RESULT_OK = "ok";
    private static final String RESULT_ERROR = "error";
    private static ViewsEngine instance;

    protected ViewsEngine() {
        IPersistenceEngine pe = null;
        try {
            pe = this.getPersistenceEngine();
            if (pe != null && !pe.classExists(View.class.getName())) {
                pe.initializeClass(View.class.getName());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while initializing Views Engine. CDF will work but no views will be available", (Throwable)e);
        }
    }

    protected IPersistenceEngine getPersistenceEngine() {
        return PersistenceEngine.getInstance();
    }

    protected ISimplePersistence getSimplePersistence() {
        return SimplePersistence.getInstance();
    }

    public static synchronized ViewsEngine getInstance() {
        if (instance == null) {
            instance = new ViewsEngine();
        }
        return instance;
    }

    public View getView(String viewName, String user) {
        try {
            ISimplePersistence sp = this.getSimplePersistence();
            Filter filter = new Filter();
            filter.where("name").equalTo((Object)viewName).and().where("user").equalTo((Object)user);
            List views = sp.load(View.class, filter);
            return views != null && views.size() > 0 ? (View)views.get(0) : null;
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting view.", (Throwable)e);
            return null;
        }
    }

    public JSONObject listViews(String user) {
        JSONObject obj = new JSONObject();
        JSONArray arr = new JSONArray();
        try {
            ISimplePersistence sp = this.getSimplePersistence();
            Filter filter = new Filter();
            filter.where("user").equalTo((Object)user);
            List views = sp.load(View.class, filter);
            for (View v : views) {
                arr.put((Object)v.toJSON());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception while writing result to json array", (Throwable)e);
            return null;
        }
        try {
            obj.put("views", (Object)arr);
            obj.put("status", (Object)RESULT_OK);
        }
        catch (JSONException e) {
            logger.warn((Object)"Exception while writing result to json object", (Throwable)e);
        }
        return obj;
    }

    public JSONObject listAllViews(String user) {
        ISimplePersistence sp;
        JSONObject response = new JSONObject();
        try {
            sp = this.getSimplePersistence();
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting view.", (Throwable)e);
            return null;
        }
        Filter filter = new Filter();
        filter.where("user").equalTo((Object)user);
        List views = sp.loadAll(View.class);
        JSONArray arr = new JSONArray();
        for (View v : views) {
            arr.put((Object)v.toJSON());
        }
        try {
            response.put("views", (Object)arr);
            response.put("status", (Object)RESULT_OK);
        }
        catch (JSONException e) {
            // empty catch block
        }
        return response;
    }

    public String saveView(String view, String user) {
        View viewObj = new View();
        IPersistenceEngine pe = null;
        try {
            pe = this.getPersistenceEngine();
        }
        catch (Exception e) {
            logger.error((Object)"Exception while getting persistence engine. View Will not be saved", (Throwable)e);
        }
        try {
            JSONObject json = new JSONObject(view);
            viewObj.fromJSON(json);
            viewObj.setUser(user);
            pe.store((Persistable)viewObj);
        }
        catch (JSONException e) {
            logger.error((Object)e);
            return RESULT_ERROR;
        }
        return RESULT_OK;
    }

    public String deleteView(String viewName, String user) {
        try {
            Filter filter = new Filter();
            filter.where("user").equalTo((Object)user).and().where("name").equalTo((Object)viewName);
            ISimplePersistence sp = this.getSimplePersistence();
            sp.delete(View.class, filter);
            return RESULT_OK;
        }
        catch (Exception e) {
            return RESULT_ERROR;
        }
    }

    public void listReports() {
    }

    public void saveReport() {
    }

    public static enum Operation {
        GET_VIEW("GETVIEW"),
        LIST_VIEWS("LISTVIEWS"),
        LIST_ALL_VIEWS("LISTALLVIEWS"),
        SAVE_VIEW("SAVEVIEW"),
        DELETE_VIEW("DELETEVIEW"),
        UNKNOWN("UNKNOWN");

        private final String operation;

        private Operation(String operation) {
            this.operation = operation;
        }

        public static Operation get(String operation) {
            try {
                return Operation.valueOf(operation.toUpperCase());
            }
            catch (Exception exception) {
                return UNKNOWN;
            }
        }
    }
}

