/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.views;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.pentaho.cdf.comments.CommentsApi;
import org.pentaho.cdf.views.ViewsEngine;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import pt.webdetails.cpf.utils.PluginIOUtils;

@Path(value="/pentaho-cdf/api/views")
public class ViewsApi {
    private static final Log logger = LogFactory.getLog(CommentsApi.class);

    @GET
    @Path(value="/list")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void listViews(@Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        String result = "";
        try {
            JSONObject json = ViewsEngine.getInstance().listViews(this.getUserName());
            result = json.toString(2);
        }
        catch (Exception e) {
            logger.error((Object)("Error listing views: " + e));
        }
        try {
            PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)result);
        }
        catch (IOException ex) {
            logger.error((Object)"Error while outputing result", (Throwable)ex);
        }
    }

    @GET
    @Path(value="/save")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void saveView(@DefaultValue(value="") @QueryParam(value="name") String view, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        try {
            String result = ViewsEngine.getInstance().saveView(view, this.getUserName());
            PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)result);
        }
        catch (Exception ex) {
            logger.error((Object)"Error while outputing result", (Throwable)ex);
        }
    }

    @GET
    @Path(value="/delete")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void deleteView(@DefaultValue(value="") @QueryParam(value="name") String name, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        try {
            String result = ViewsEngine.getInstance().deleteView(name, this.getUserName());
            PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)result);
        }
        catch (IOException ex) {
            logger.error((Object)"Error while outputing result", (Throwable)ex);
        }
    }

    private String getUserName() {
        return PentahoSessionHolder.getSession().getName();
    }
}

