/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cpf.persistence.Persistable;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class View
implements Persistable {
    private static final Log logger = LogFactory.getLog(View.class);
    private Map<String, Object> parameters;
    private Map<String, Object> userData;
    private List<String> unboundParams;
    private String name;
    private String viewId;
    private String user;
    private String description;
    private String key;
    private String solution;
    private String path;
    private String file;
    private Date timestamp;

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setUserData(String name, Object value) {
        this.userData.put(name, value);
    }

    public Object getUserData(String name) {
        return this.userData.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.viewId;
    }

    public void setId(String id) {
        this.viewId = id;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public JSONObject toJSON() {
        try {
            BASE64Encoder base64Encoder = new BASE64Encoder();
            JSONObject json = new JSONObject();
            json.put("description", (Object)this.description);
            json.put("name", (Object)this.name);
            json.put("id", (Object)this.viewId);
            json.put("key", (Object)this.key);
            json.put("timestamp", this.timestamp == null ? 0L : this.timestamp.getTime());
            json.put("user", (Object)this.user);
            json.put("unbound", (Object)new JSONArray(this.unboundParams));
            String p = new String(base64Encoder.encode(new JSONObject(this.parameters).toString(2).getBytes()));
            json.put("params", (Object)p);
            if (this.userData != null) {
                String u = new String(base64Encoder.encode(new JSONObject(this.userData).toString(2).getBytes()));
                json.put("userData", (Object)u);
            }
            json.put("solution", (Object)this.solution);
            json.put("path", (Object)this.path);
            json.put("file", (Object)this.file);
            return json;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public void fromJSON(JSONObject json) throws JSONException {
        try {
            JSONObject jsonParams;
            BASE64Decoder base64Decoder = new BASE64Decoder();
            HashMap<String, Object> _params = new HashMap<String, Object>();
            HashMap<String, Object> _userData = new HashMap<String, Object>();
            String _description = json.optString("description");
            String _name = json.getString("name");
            String _id = json.getString("id");
            Date _timestamp = new Date(json.optLong("timestamp", 0L));
            String _user = json.getString("user");
            String _key = json.isNull("key") ? null : json.optString("key");
            String _solution = json.getString("solution");
            String _path = json.getString("path");
            String _file = json.getString("file");
            String p = json.getString("params");
            try {
                jsonParams = new JSONObject(new String(base64Decoder.decodeBuffer(p)));
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw new JSONException((Throwable)e);
            }
            JSONArray jsonUnbound = json.getJSONArray("unbound");
            String[] keys = JSONObject.getNames((JSONObject)jsonParams);
            if (keys != null) {
                for (String k : keys) {
                    _params.put(k, jsonParams.get(k));
                }
            }
            ArrayList<String> _unbound = new ArrayList<String>();
            for (int i = 0; i < jsonUnbound.length(); ++i) {
                _unbound.add(jsonUnbound.getString(i));
            }
            if (json.has("userData")) {
                JSONObject jsonUserData;
                String u = json.getString("userData");
                try {
                    jsonUserData = new JSONObject(new String(base64Decoder.decodeBuffer(u)));
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    throw new JSONException((Throwable)e);
                }
                String[] userDataKeys = JSONObject.getNames((JSONObject)jsonUserData);
                if (userDataKeys != null) {
                    for (String k : userDataKeys) {
                        _userData.put(k, jsonUserData.get(k));
                    }
                }
            } else {
                _userData = null;
            }
            this.name = _name;
            this.user = _user;
            this.description = _description;
            this.viewId = _id;
            this.key = _key;
            this.timestamp = _timestamp;
            this.parameters = _params;
            this.userData = _userData;
            this.unboundParams = _unbound;
            this.solution = _solution;
            this.path = _path;
            this.file = _file;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

