/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.storage;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.InvalidCdfOperationException;
import org.pentaho.cdf.PluginHibernateException;
import org.pentaho.cdf.storage.StorageEngine;
import org.pentaho.cdf.utils.JsonUtil;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;

@Path(value="/pentaho-cdf/api/storage")
public class StorageApi {
    private static final Log logger = LogFactory.getLog(StorageApi.class);

    @GET
    @Path(value="/store")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    public Response store(@QueryParam(value="storageValue") String storageValue) throws InvalidCdfOperationException, JSONException, PluginHibernateException {
        JSONObject json = StorageEngine.getInstance().store(storageValue, this.getUserName());
        return JsonUtil.isSuccessResponse((JSONObject)json) ? Response.ok((Object)json.toString(2)).build() : Response.serverError().build();
    }

    @GET
    @Path(value="/read")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    public String read() throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        JSONObject json = StorageEngine.getInstance().read(this.getUserName());
        if (json != null) {
            return json.toString();
        }
        logger.error((Object)"json object is null");
        return "error";
    }

    @GET
    @Path(value="/delete")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    public Response delete() throws JSONException, InvalidCdfOperationException, PluginHibernateException {
        JSONObject json = StorageEngine.getInstance().delete(this.getUserName());
        return JsonUtil.isSuccessResponse((JSONObject)json) ? Response.ok((Object)json.toString(2)).build() : Response.serverError().build();
    }

    private String getUserName() {
        return PentahoSessionHolder.getSession().getName();
    }
}

