/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.render;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.pentaho.cdf.CdfConstants;
import org.pentaho.cdf.context.ContextEngine;
import org.pentaho.cdf.environment.CdfEngine;
import org.pentaho.cdf.environment.packager.ICdfHeadersProvider;
import org.pentaho.cdf.environment.templater.ITemplater;
import org.pentaho.cdf.localization.MessageBundlesHelper;
import org.pentaho.cdf.render.HtmlDashboardRenderer;
import org.pentaho.cdf.storage.StorageEngine;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

public class CdfHtmlRenderer {
    private static Log logger = LogFactory.getLog(CdfHtmlRenderer.class);

    public void execute(OutputStream out, String solution, String path, String templateName, String style, String dashboardsMessagesBaseFilename, HashMap<String, String> parameterMap, String user, int inactiveInterval) throws Exception {
        IBasicFile dashboardTemplateFile = HtmlDashboardRenderer.getDashboardTemplate((String)solution, (String)path, (String)templateName);
        this.execute(out, dashboardTemplateFile, style, dashboardsMessagesBaseFilename, parameterMap, user, inactiveInterval);
    }

    public void execute(OutputStream out, String templatePath, String style, String dashboardsMessagesBaseFilename, HashMap<String, String> parameterMap, String user, int inactiveInterval) throws Exception {
        IBasicFile dashboardTemplateFile = HtmlDashboardRenderer.getDashboardTemplate((String)templatePath);
        this.execute(out, dashboardTemplateFile, style, dashboardsMessagesBaseFilename, parameterMap, user, inactiveInterval);
    }

    public void execute(OutputStream out, IBasicFile dashboardTemplateFile, String style, String dashboardsMessagesBaseFilename, HashMap<String, String> parameterMap, String user, int inactiveInterval) throws Exception {
        String templateContent;
        String intro = "";
        String footer = "";
        IReadAccess systemAccess = CdfEngine.getPluginSystemReader(null);
        style = StringUtils.isEmpty((String)style) ? "" : "-" + style;
        String dashboardTemplate = "template-dashboard" + style + ".html";
        ArrayList<String> i18nTagsList = new ArrayList<String>();
        IBasicFile templateResourceFile = null;
        IReadAccess pluginRepoAccess = CdfEngine.getPluginRepositoryReader((String)"templates/");
        if (pluginRepoAccess.fileExists(dashboardTemplate)) {
            templateResourceFile = pluginRepoAccess.fetchFile(dashboardTemplate);
        } else if (systemAccess.fileExists(dashboardTemplate)) {
            templateResourceFile = systemAccess.fetchFile(dashboardTemplate);
        }
        if (templateResourceFile != null) {
            templateContent = Util.toString((InputStream)templateResourceFile.getContents());
        } else {
            logger.error((Object)("Template " + dashboardTemplate + "not available on cdf/templates, loading fallback instead"));
            templateContent = Util.toString((InputStream)systemAccess.fetchFile("template-dashboard.html").getContents());
        }
        templateContent = this.updateUserLanguageKey(templateContent);
        templateContent = this.processi18nTags(templateContent, i18nTagsList);
        ITemplater templater = CdfEngine.getEnvironment().getTemplater();
        intro = templater.getTemplateSection(templateContent, ITemplater.Section.HEADER);
        footer = templater.getTemplateSection(templateContent, ITemplater.Section.FOOTER);
        String dashboardContent = this.getDashboardContent(dashboardTemplateFile.getContents(), i18nTagsList);
        String path = StringUtils.defaultIfEmpty((String)FilenameUtils.getPathNoEndSeparator((String)dashboardTemplateFile.getPath()), (String)CdfEngine.getEnvironment().getCdfPluginRepositoryDir());
        path = !path.startsWith(String.valueOf('/')) ? '/' + path : path;
        MessageBundlesHelper mbh = new MessageBundlesHelper(path, dashboardsMessagesBaseFilename);
        intro = this.replaceIntroParameters(intro, mbh, i18nTagsList, dashboardsMessagesBaseFilename);
        int headIndex = intro.indexOf("<head>");
        int length = intro.length();
        out.write(intro.substring(0, headIndex + 6).getBytes(CharsetHelper.getEncoding()));
        CdfHtmlRenderer.getHeaders(dashboardContent, parameterMap, out);
        out.write(intro.substring(headIndex + 6, length).getBytes(CharsetHelper.getEncoding()));
        try {
            ContextEngine.generateContext(out, parameterMap, inactiveInterval);
        }
        catch (Exception e) {
            logger.error((Object)"Error generating cdf context.", (Throwable)e);
        }
        try {
            this.generateStorage(out, user);
        }
        catch (Exception e) {
            logger.error((Object)"Error in cdf storage.", (Throwable)e);
        }
        out.write("<div id=\"dashboardContent\">".getBytes(CharsetHelper.getEncoding()));
        out.write(dashboardContent.getBytes(CharsetHelper.getEncoding()));
        out.write("</div>".getBytes(CharsetHelper.getEncoding()));
        out.write(footer.getBytes(CharsetHelper.getEncoding()));
    }

    public boolean matchComponent(int keyIndex, String key, String content) {
        for (int i = keyIndex - 1; i > 0; --i) {
            if (content.charAt(i) == ':' || content.charAt(i) == '\"' || ("" + content.charAt(i)).trim().equals("")) continue;
            if (i - 3 <= 0 || !content.substring(i - 3, i + 1).equals("type")) break;
            return true;
        }
        if ((keyIndex = content.indexOf(key, keyIndex + key.length())) != -1) {
            return this.matchComponent(keyIndex, key, content);
        }
        return false;
    }

    private String getDashboardContent(InputStream is, ArrayList<String> i18nTagsList) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName(CdfEngine.getEnvironment().getSystemEncoding())));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            line = this.processi18nTags(line, i18nTagsList);
            sb.append(line + "\n");
        }
        is.close();
        return sb.toString();
    }

    private String processi18nTags(String content, ArrayList<String> tagsList) {
        String tagPattern = "CDF.i18n\\(\"";
        String[] test = content.split(tagPattern);
        if (test.length == 1) {
            return content;
        }
        StringBuffer resBuffer = new StringBuffer();
        resBuffer.append(test[0]);
        for (int i = 1; i < test.length; ++i) {
            resBuffer.append("<span id=\"");
            if (i == 0) continue;
            String tagValue = test[i].substring(0, test[i].indexOf("\")"));
            tagsList.add(tagValue);
            resBuffer.append(this.updateSelectorName(tagValue));
            resBuffer.append("\"></span>");
            resBuffer.append(test[i].substring(test[i].indexOf("\")") + 2, test[i].length()));
        }
        return resBuffer.toString();
    }

    private String updateSelectorName(String name) {
        return name.replace(".", "_");
    }

    private String replaceIntroParameters(String intro, MessageBundlesHelper mbh, ArrayList<String> i18nTagsList, String dashboardsMessagesBaseFilename) throws Exception {
        mbh.saveI18NMessageFilesToCache();
        String messageSetPath = mbh.getMessageFilesCacheUrl() + "/";
        if (dashboardsMessagesBaseFilename == null) {
            dashboardsMessagesBaseFilename = "Messages";
        }
        intro = intro.replaceAll("\\{load\\}", "onload=\"load()\"");
        intro = intro.replaceAll("\\{body-tag-unload\\}", "");
        intro = intro.replaceAll("#\\{GLOBAL_MESSAGE_SET_NAME\\}", dashboardsMessagesBaseFilename);
        intro = intro.replaceAll("#\\{GLOBAL_MESSAGE_SET_PATH\\}", messageSetPath);
        intro = intro.replaceAll("#\\{GLOBAL_MESSAGE_SET\\}", this.buildMessageSetCode(i18nTagsList));
        return intro;
    }

    private String buildMessageSetCode(ArrayList<String> tagsList) {
        StringBuffer messageCodeSet = new StringBuffer();
        for (String tag : tagsList) {
            messageCodeSet.append("\\$('#").append(this.updateSelectorName(tag)).append("').html(jQuery.i18n.prop('").append(tag).append("'));\n");
        }
        return messageCodeSet.toString();
    }

    private String updateUserLanguageKey(String intro) {
        intro = intro.replaceAll("#\\{LANGUAGE_CODE\\}", CdfEngine.getEnvironment().getLocale().getLanguage());
        return intro;
    }

    public static void getHeaders(HashMap<String, String> paramMap, OutputStream out) throws Exception {
        String dashboardContent = StringUtils.defaultString((String)paramMap.get("dashboardContent"));
        CdfHtmlRenderer.getHeaders(dashboardContent, paramMap, out);
    }

    public static void getHeaders(String dashboardContent, HashMap<String, String> paramMap, OutputStream out) throws Exception {
        String dashboardType = StringUtils.defaultIfEmpty((String)paramMap.get("dashboardType"), (String)"blueprint");
        boolean isDebugMode = Boolean.TRUE.toString().equalsIgnoreCase(paramMap.get("debug"));
        String root = StringUtils.defaultString((String)paramMap.get("root"));
        String scheme = StringUtils.defaultIfEmpty((String)paramMap.get("scheme"), (String)"http");
        boolean absolute = StringUtils.defaultIfEmpty((String)paramMap.get("absolute"), (String)"false").equals("true");
        CdfHtmlRenderer.getHeaders(dashboardContent, dashboardType, absolute, root, scheme, isDebugMode, out);
    }

    public static void getHeaders(String dashboardContent, String dashboardType, boolean absolute, String root, String scheme, boolean isDebugMode, OutputStream out) throws Exception {
        ICdfHeadersProvider cdfHeaders = CdfEngine.getEnvironment().getCdfHeadersProvider();
        ArrayList<String> componentTypes = new ArrayList<String>(CdfConstants.DASHBOARD_COMPONENT_TYPES.length);
        if (dashboardContent != null) {
            componentTypes = new ArrayList();
            for (String[] componenType : CdfConstants.DASHBOARD_COMPONENT_TYPES) {
                if (!Pattern.compile(String.format("type:\\s*[\"'](?i)%s[a-z]*[\"']", componenType[0])).matcher(dashboardContent).find()) continue;
                componentTypes.add(componenType[1]);
            }
        }
        if (absolute) {
            String webRoot;
            if (!StringUtils.isEmpty((String)root)) {
                if (root.contains("/")) {
                    root = root.substring(0, root.indexOf("/"));
                }
                webRoot = scheme + "://" + root;
            } else {
                webRoot = CdfEngine.getEnvironment().getPathProvider().getWebappContextRoot();
            }
            out.write(cdfHeaders.getHeaders(dashboardType, isDebugMode, webRoot, componentTypes).getBytes(CharsetHelper.getEncoding()));
        } else {
            out.write(cdfHeaders.getHeaders(dashboardType, isDebugMode, componentTypes).getBytes(CharsetHelper.getEncoding()));
        }
    }

    private void generateStorage(OutputStream out, String user) throws Exception {
        JSONObject result = StorageEngine.getInstance().read(user);
        StringBuilder s = new StringBuilder();
        s.append("\n<script language=\"javascript\" type=\"text/javascript\">\n");
        s.append("  Dashboards.storage = ");
        s.append(result.toString(2)).append("\n");
        s.append("</script>\n");
        out.write(s.toString().getBytes(CharsetHelper.getEncoding()));
    }
}

