/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.pentaho.cdf.Messages;
import org.pentaho.cdf.export.Export;
import org.pentaho.cdf.export.IExport;

public class ExportCSV
extends Export
implements IExport {
    private static final String extensionFile = ".csv";

    public ExportCSV(OutputStream out) throws IOException {
        super(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(String[][] resultSet) {
        PrintWriter pw = new PrintWriter(this.outputStream);
        try {
            for (int i = 0; i < resultSet.length; ++i) {
                String value;
                String[] vs = resultSet[i];
                for (int j = 0; j < vs.length && (value = vs[j]) != null; ++j) {
                    if (this.isDouble(value)) {
                        pw.append(new Double(value).toString());
                    } else {
                        String aux = value.replaceAll("\"", "\\\\\"");
                        pw.append('\"' + aux + '\"');
                    }
                    if (j + 1 >= vs.length) continue;
                    pw.append(',');
                }
                pw.append('\n');
            }
            pw.flush();
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString((String)"CdfExportCSV.ERROR_0001_BUILDING_CSV"));
        }
        finally {
            pw.close();
        }
    }

    @Override
    public String getExtension() {
        return extensionFile;
    }
}

