/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.comments;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.pentaho.cdf.comments.CommentsEngine;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;
import pt.webdetails.cpf.utils.CharsetHelper;
import pt.webdetails.cpf.utils.PluginIOUtils;

@Path(value="/pentaho-cdf/api/comments")
public class CommentsApi {
    private static final Log logger = LogFactory.getLog(CommentsApi.class);

    @GET
    @Path(value="/add")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void add(@DefaultValue(value="") @QueryParam(value="page") String page, @DefaultValue(value="") @QueryParam(value="comment") String comment, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        String result = "";
        try {
            JSONObject json = CommentsEngine.getInstance().add(page, comment, this.getUserName());
            result = json.toString(2);
        }
        catch (Exception e) {
            logger.error((Object)("Error processing comment: " + e));
        }
        try {
            PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)result);
        }
        catch (IOException ex) {
            logger.error((Object)"Error while outputing result", (Throwable)ex);
        }
    }

    @GET
    @Path(value="/list")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void list(@DefaultValue(value="") @QueryParam(value="page") String page, @DefaultValue(value="0") @QueryParam(value="firstResult") int firstResult, @DefaultValue(value="20") @QueryParam(value="maxResults") int maxResults, @DefaultValue(value="false") @QueryParam(value="deleted") boolean deleted, @DefaultValue(value="false") @QueryParam(value="archived") boolean archived, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        String result = "";
        boolean isAdministrator = SecurityHelper.getInstance().isPentahoAdministrator(PentahoSessionHolder.getSession());
        if (deleted && !isAdministrator) {
            deleted = false;
            logger.warn((Object)"only admin users are allowed to see deleted comments");
        }
        if (archived && !isAdministrator) {
            archived = false;
            logger.warn((Object)"only admin users are allowed to see archived comments");
        }
        try {
            JSONObject json = CommentsEngine.getInstance().list(page, firstResult, maxResults, deleted, archived, this.getUserName());
            result = json.toString(2);
        }
        catch (Exception e) {
            logger.error((Object)("Error processing comment: " + e));
        }
        try {
            PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)result);
        }
        catch (IOException ex) {
            logger.error((Object)"Error while outputing result", (Throwable)ex);
        }
    }

    @GET
    @Path(value="/archive")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void archive(@DefaultValue(value="0") @QueryParam(value="commentId") int commentId, @DefaultValue(value="true") @QueryParam(value="value") boolean value, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        String result = "";
        boolean isAdministrator = SecurityHelper.getInstance().isPentahoAdministrator(PentahoSessionHolder.getSession());
        boolean isAuthenticated = PentahoSessionHolder.getSession().isAuthenticated();
        if (!isAuthenticated) {
            String msg = "Operation not authorized: requires authentication";
            logger.error((Object)msg);
            try {
                IOUtils.write((String)msg, (OutputStream)servletResponse.getOutputStream(), (String)CharsetHelper.getEncoding());
            }
            catch (IOException ex) {
                logger.error((Object)"Error while outputing result", (Throwable)ex);
            }
            return;
        }
        try {
            JSONObject json = CommentsEngine.getInstance().archive(commentId, value, this.getUserName(), isAdministrator);
            result = json.toString(2);
        }
        catch (Exception e) {
            logger.error((Object)("Error processing comment: " + e));
        }
        try {
            PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)result);
        }
        catch (IOException ex) {
            logger.error((Object)"Error while outputing result", (Throwable)ex);
        }
    }

    @GET
    @Path(value="/delete")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void delete(@DefaultValue(value="0") @QueryParam(value="commentId") int commentId, @DefaultValue(value="true") @QueryParam(value="value") boolean value, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        String result = "";
        boolean isAdministrator = SecurityHelper.getInstance().isPentahoAdministrator(PentahoSessionHolder.getSession());
        boolean isAuthenticated = PentahoSessionHolder.getSession().isAuthenticated();
        if (!isAuthenticated) {
            String msg = "Operation not authorized: requires authentication";
            logger.error((Object)msg);
            try {
                PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)msg);
            }
            catch (IOException ex) {
                logger.error((Object)"Error while outputing result", (Throwable)ex);
            }
            return;
        }
        try {
            JSONObject json = CommentsEngine.getInstance().delete(commentId, value, this.getUserName(), isAdministrator);
            result = json.toString(2);
        }
        catch (Exception ex) {
            logger.error((Object)("Error processing comment: " + ex));
        }
        try {
            PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)result);
        }
        catch (IOException ex) {
            logger.error((Object)"Error while outputing result", (Throwable)ex);
        }
    }

    private String getUserName() {
        return PentahoSessionHolder.getSession().getName();
    }
}

