/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.utils.JsonUtil;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class NavigateComponent {
    private static final Log logger = LogFactory.getLog(NavigateComponent.class);
    private static final String TYPE_FOLDER = "FOLDER";
    private static final String HIDDEN_DESC = "Hidden";
    private static final String SEPARATOR = String.valueOf('/');

    public static JSONObject getJSONSolution(String path, int depth, boolean showHiddenFiles, String mode) {
        JSONObject jsonRoot = new JSONObject();
        try {
            path = StringUtils.defaultIfEmpty((String)path, (String)SEPARATOR);
            RepositoryFileTree tree = ((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class)).getTree(path, depth, "*", false);
            if (tree != null) {
                if (mode.equalsIgnoreCase("navigator")) {
                    JSONObject json = new JSONObject();
                    NavigateComponent.processTree(tree, json, false, showHiddenFiles, path);
                    jsonRoot.put("solution", (Object)json);
                } else if (mode.equalsIgnoreCase("contentList")) {
                    jsonRoot = NavigateComponent.repositoryFileToJSONObject(tree.getFile());
                    jsonRoot.put("content", (Object)new JSONArray());
                    jsonRoot.remove("files");
                    jsonRoot.remove("folders");
                    NavigateComponent.processContentListTree(tree, jsonRoot, showHiddenFiles, path);
                } else if (mode.equalsIgnoreCase("solutionTree")) {
                    JSONObject json = new JSONObject();
                    NavigateComponent.processTree(tree, json, true, showHiddenFiles, path);
                    jsonRoot.put("solution", (Object)json);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            jsonRoot = JsonUtil.makeJsonErrorResponse((String)e.getMessage(), (boolean)false);
        }
        return jsonRoot;
    }

    public static void processTree(RepositoryFileTree tree, JSONObject json, boolean includeAllFiles, boolean showHiddenFiles, String rootDir) throws Exception {
        block6: {
            JSONObject childJson;
            block4: {
                block5: {
                    rootDir = StringUtils.defaultIfEmpty((String)rootDir, (String)SEPARATOR);
                    if (!showHiddenFiles && tree.getFile().isHidden()) {
                        return;
                    }
                    childJson = NavigateComponent.repositoryFileToJSONObject(tree.getFile());
                    if (tree.getFile().isFolder()) break block4;
                    if (!includeAllFiles) break block5;
                    json.append("files", (Object)childJson);
                    break block6;
                }
                String type = StringUtils.defaultIfEmpty((String)childJson.getString("type"), (String)"");
                if (!"wcdf".equalsIgnoreCase(type) && !"xcdf".equalsIgnoreCase(type)) break block6;
                json.append("files", (Object)childJson);
                break block6;
            }
            json.append("folders", (Object)childJson);
            if (tree.getChildren() != null) {
                for (RepositoryFileTree childNode : tree.getChildren()) {
                    if (rootDir.equals(tree.getFile().getPath()) && NavigateComponent.isSystemFolder(childNode)) {
                        return;
                    }
                    NavigateComponent.processTree(childNode, childJson, includeAllFiles, showHiddenFiles, rootDir);
                }
            }
        }
    }

    public static void processContentListTree(RepositoryFileTree tree, JSONObject json, boolean showHiddenFiles, String rootDir) throws Exception {
        JSONObject childJson = NavigateComponent.repositoryFileToJSONObject(tree.getFile());
        if (!tree.getFile().isFolder()) {
            if (!showHiddenFiles && tree.getFile().isHidden()) {
                return;
            }
            json.append("content", (Object)childJson);
        } else {
            if (!rootDir.equals(tree.getFile().getPath())) {
                json.append("content", (Object)childJson);
            }
            if (tree.getChildren() != null) {
                for (RepositoryFileTree childNode : tree.getChildren()) {
                    NavigateComponent.processContentListTree(childNode, json, showHiddenFiles, rootDir);
                }
            }
        }
    }

    public static JSONObject repositoryFileToJSONObject(RepositoryFile file) throws JSONException {
        if (file != null) {
            JSONObject json = new JSONObject();
            json.put("id", (Object)file.getId());
            json.put("name", (Object)StringUtils.defaultString((String)file.getName()));
            json.put("path", (Object)StringUtils.defaultString((String)file.getPath()));
            json.put("visible", !file.isHidden());
            json.put("title", (Object)(file.isHidden() ? HIDDEN_DESC : StringUtils.defaultString((String)file.getTitle())));
            json.put("description", (Object)StringUtils.defaultString((String)file.getDescription()));
            json.put("creatorId", (Object)StringUtils.defaultString((String)file.getCreatorId()));
            json.put("locked", file.isLocked());
            if (file.isFolder()) {
                json.put("type", (Object)TYPE_FOLDER);
                json.put("files", (Object)new JSONArray());
                json.put("folders", (Object)new JSONArray());
            } else {
                json.put("link", (Object)StringUtils.defaultString((String)("/api/repos/" + file.getPath().replaceAll(SEPARATOR, ":") + "/generatedContent")));
                json.put("type", (Object)FilenameUtils.getExtension((String)file.getName()));
            }
            return json;
        }
        return null;
    }

    private static boolean isSystemFolder(RepositoryFileTree folder) {
        if (folder != null && folder.getFile() != null && folder.getFile().isFolder()) {
            Map meta = ((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class)).getFileMetadata(folder.getFile().getId());
            return meta.containsKey("system_folder") ? (Boolean)meta.get("system_folder") : false;
        }
        return false;
    }
}

