/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.pentaho.cdf.InvalidCdfOperationException;
import org.pentaho.cdf.NavigateComponent;
import org.pentaho.cdf.context.ContextEngine;
import org.pentaho.cdf.environment.CdfEngine;
import org.pentaho.cdf.export.Export;
import org.pentaho.cdf.export.ExportCSV;
import org.pentaho.cdf.export.ExportExcel;
import org.pentaho.cdf.render.CdfHtmlRenderer;
import org.pentaho.cdf.util.Parameter;
import org.pentaho.cdf.xactions.ActionEngine;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.web.MimeHelper;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.PluginIOUtils;

@Path(value="/pentaho-cdf/api")
public class CdfApi {
    private static final Log logger = LogFactory.getLog(CdfApi.class);

    @GET
    @Path(value="/ping")
    @Produces(value={"text/plain"})
    public Response doGetPing() throws InvalidCdfOperationException {
        return Response.ok((Object)"{\"ping\":\"ok\"}").build();
    }

    @POST
    @Path(value="/ping")
    @Produces(value={"text/plain"})
    public Response doPostPing() throws InvalidCdfOperationException {
        return Response.ok((Object)"{\"ping\":\"ok\"}").build();
    }

    @GET
    @Path(value="/getResource")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void getResource(@QueryParam(value="resource") String resource, @QueryParam(value="path") String path, @Context HttpServletResponse response) throws Exception {
        try {
            if (!StringUtils.isEmpty((String)resource) && StringUtils.isEmpty((String)path)) {
                path = resource;
            }
            path = path != null && path.endsWith("/content") ? path.substring(0, path.indexOf("/content")) : path;
            response.setHeader("Content-Type", MimeHelper.getMimeTypeFromFileName((String)path));
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            String formats = resLoader.getPluginSetting(this.getClass(), "settings/resources/downloadable-formats");
            List<String> allowedFormats = Arrays.asList(StringUtils.split((String)formats, (char)','));
            String extension = path.replaceAll(".*\\.(.*)", "$1");
            if (allowedFormats.indexOf(extension) < 0) {
                throw new SecurityException("Not allowed");
            }
            IReadAccess systemAccess = CdfEngine.getPluginSystemReader(null);
            if (!systemAccess.fileExists(path)) {
                logger.warn((Object)("resource does not exist: " + path));
                return;
            }
            PluginIOUtils.writeOutAndFlush((OutputStream)response.getOutputStream(), (InputStream)systemAccess.getFileInputStream(path));
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            logger.error((Object)e);
            response.sendError(403);
        }
    }

    @POST
    @Path(value="/getResource")
    public void postResource(@QueryParam(value="resource") String resource, @QueryParam(value="path") String path, @Context HttpServletResponse response) throws Exception {
        this.getResource(resource, path, response);
    }

    @GET
    @Path(value="/getContext")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public String getContext(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="action") @DefaultValue(value="") String action, @DefaultValue(value="") @QueryParam(value="viewId") String viewId, @Context HttpServletRequest servletRequest) {
        int inactiveInterval = servletRequest.getSession().getMaxInactiveInterval();
        return ContextEngine.getInstance().getContext(path, viewId, action, Parameter.asHashMap(servletRequest), inactiveInterval);
    }

    @GET
    @Path(value="/clearCache")
    public void clearCache(@Context HttpServletResponse servletResponse) {
        try {
            ContextEngine.clearCache();
            PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)"Cache Cleared");
        }
        catch (IOException e) {
            logger.error((Object)"failed to clear CDFcache");
        }
    }

    @GET
    @Path(value="/export")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void export(@QueryParam(value="solution") String solution, @QueryParam(value="path") String path, @QueryParam(value="action") String action, @QueryParam(value="contentType") @DefaultValue(value="text/html") String contentType, @QueryParam(value="exportType") @DefaultValue(value="excel") String exportType, @Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        String value = this.determineCorrectPath(solution, action, path);
        if (ActionEngine.getInstance().executeAction(value, contentType, request, response, PentahoSessionHolder.getSession(), Parameter.asHashMap(request))) {
            Export export;
            if ("csv".equalsIgnoreCase(exportType)) {
                export = new ExportCSV((OutputStream)response.getOutputStream());
                response.setHeader("Content-Type", "text/csv");
            } else {
                export = new ExportExcel((OutputStream)response.getOutputStream());
                response.setHeader("Content-Type", "application/msexcel");
            }
            response.setHeader("Cache-Control", "max-age=0, no-store");
            response.setHeader("content-disposition", "attachment; filename=export" + export.getExtension());
            export.exportFile(new JSONObject((Object)response.getOutputStream()));
        }
    }

    @GET
    @Path(value="/callAction")
    public void callAction(@QueryParam(value="solution") String solution, @QueryParam(value="path") String path, @QueryParam(value="action") String action, @QueryParam(value="contentType") @DefaultValue(value="text/html") String contentType, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws Exception {
        String value = this.determineCorrectPath(solution, action, path);
        ActionEngine.getInstance().executeAction(value, contentType, servletRequest, servletResponse, PentahoSessionHolder.getSession(), Parameter.asHashMap(servletRequest));
    }

    @GET
    @Path(value="/getJSONSolution")
    @Produces(value={"application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public void getJSONSolution(@QueryParam(value="solution") String solution, @QueryParam(value="path") @DefaultValue(value="/") String path, @QueryParam(value="action") String action, @QueryParam(value="depth") @DefaultValue(value="-1") int depth, @QueryParam(value="showHiddenFiles") @DefaultValue(value="false") boolean showHiddenFiles, @QueryParam(value="mode") @DefaultValue(value="*") String mode, @Context HttpServletResponse servletResponse) throws InvalidCdfOperationException {
        String value = this.determineCorrectPath(solution, action, path);
        try {
            JSONObject jsonRoot = NavigateComponent.getJSONSolution(value, depth, showHiddenFiles, mode);
            PrintWriter pw = new PrintWriter((OutputStream)servletResponse.getOutputStream());
            pw.println(jsonRoot);
            pw.flush();
        }
        catch (Throwable t) {
            throw new InvalidCdfOperationException(t.getMessage());
        }
    }

    @GET
    @Path(value="/viewAction")
    public void doGetViewAction(@QueryParam(value="solution") String solution, @QueryParam(value="path") String path, @QueryParam(value="action") String action, @QueryParam(value="contentType") @DefaultValue(value="text/html") String contentType, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws Exception {
        this.doPostViewAction(solution, path, action, contentType, null, null, null, null, servletRequest, servletResponse);
    }

    @POST
    @Path(value="/viewAction")
    public void doPostViewAction(@QueryParam(value="solution") String solution, @QueryParam(value="path") String path, @QueryParam(value="action") String action, @QueryParam(value="contentType") @DefaultValue(value="text/html") String contentType, @FormParam(value="queryType") String queryType, @FormParam(value="query") String query, @FormParam(value="catalog") String catalog, @FormParam(value="jndi") String jndi, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws Exception {
        boolean success;
        String value = this.determineCorrectPath(solution, action, path);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)queryType) && !paramMap.containsKey("queryType")) {
            paramMap.put("queryType", queryType);
        }
        if (!StringUtils.isEmpty((String)query) && !paramMap.containsKey("query")) {
            paramMap.put("query", query);
        }
        if (!StringUtils.isEmpty((String)catalog) && !paramMap.containsKey("catalog")) {
            paramMap.put("catalog", catalog);
        }
        if (!StringUtils.isEmpty((String)jndi) && !paramMap.containsKey("jndi")) {
            paramMap.put("jndi", jndi);
        }
        if (success = ActionEngine.getInstance().executeAction(value, contentType, servletRequest, servletResponse, PentahoSessionHolder.getSession(), paramMap)) {
            servletResponse.getOutputStream().flush();
        }
    }

    @GET
    @Path(value="/getHeaders")
    @Produces(value={"text/html"})
    public String getHeaders(@QueryParam(value="dashboardContent") String dashboardContent, @QueryParam(value="dashboardType") String dashboardType, @QueryParam(value="absolute") @DefaultValue(value="false") String absolute, @QueryParam(value="root") String root, @QueryParam(value="scheme") String scheme, @QueryParam(value="debug") @DefaultValue(value="false") String debug, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws Exception {
        try {
            CdfHtmlRenderer.getHeaders(dashboardContent, dashboardType, Boolean.parseBoolean(absolute), root, scheme, Boolean.parseBoolean(debug), (OutputStream)servletResponse.getOutputStream());
        }
        catch (IOException ex) {
            logger.error((Object)("getHeaders: " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        return null;
    }

    private String determineCorrectPath(String solution, String action, String path) {
        String value = "";
        if (!StringUtils.isEmpty((String)solution) || !StringUtils.isEmpty((String)action)) {
            value = Util.joinPath((String[])new String[]{solution, path, action});
        } else if (!StringUtils.isEmpty((String)path)) {
            value = path;
        }
        return value;
    }
}

