/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jpivot;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.mondrian.MondrianModelComponent;
import org.pentaho.platform.util.messages.LocaleHelper;

public class PivotViewComponent
extends ComponentBase {
    public static final String MODE = "mode";
    public static final String MODEL = "model";
    public static final String OPTIONS = "options";
    public static final String CONNECTION = "connection";
    public static final String TITLE = "title";
    public static final String URL = "url";
    public static final String VIEWER = "viewer";
    public static final String EXECUTE = "execute";
    public static final String SHOWGRID = "showgrid";
    public static final String CHARTTYPE = "charttype";
    public static final String CHARTLOCATION = "chartlocation";
    public static final String CHARTWIDTH = "chartwidth";
    public static final String CHARTHEIGHT = "chartheight";
    public static final String CHARTDRILLTHROUGHENABLED = "chartdrillthroughenabled";
    public static final String CHARTTITLE = "charttitle";
    public static final String CHARTTITLEFONTFAMILY = "charttitlefontfamily";
    public static final String CHARTTITLEFONTSTYLE = "charttitlefontstyle";
    public static final String CHARTTITLEFONTSIZE = "charttitlefontsize";
    public static final String CHARTHORIZAXISLABEL = "charthorizaxislabel";
    public static final String CHARTVERTAXISLABEL = "chartvertaxislabel";
    public static final String CHARTAXISLABELFONTFAMILY = "chartaxislabelfontfamily";
    public static final String CHARTAXISLABELFONTSTYLE = "chartaxislabelfontstyle";
    public static final String CHARTAXISLABELFONTSIZE = "chartaxislabelfontsize";
    public static final String CHARTAXISTICKFONTFAMILY = "chartaxistickfontfamily";
    public static final String CHARTAXISTICKFONTSTYLE = "chartaxistickfontstyle";
    public static final String CHARTAXISTICKFONTSIZE = "chartaxistickfontsize";
    public static final String CHARTAXISTICKLABELROTATION = "chartaxisticklabelrotation";
    public static final String CHARTSHOWLEGEND = "chartshowlegend";
    public static final String CHARTLEGENDLOCATION = "chartlegendlocation";
    public static final String CHARTLEGENDFONTFAMILY = "chartlegendfontfamily";
    public static final String CHARTLEGENDFONTSTYLE = "chartlegendfontstyle";
    public static final String CHARTLEGENDFONTSIZE = "chartlegendfontsize";
    public static final String CHARTSHOWSLICER = "chartshowslicer";
    public static final String CHARTSLICERLOCATION = "chartslicerlocation";
    public static final String CHARTSLICERALIGNMENT = "chartsliceralignment";
    public static final String CHARTSLICERFONTFAMILY = "chartslicerfontfamily";
    public static final String CHARTSLICERFONTSTYLE = "chartslicerfontstyle";
    public static final String CHARTSLICERFONTSIZE = "chartslicerfontsize";
    public static final String CHARTBACKGROUNDR = "chartbackgroundr";
    public static final String CHARTBACKGROUNDG = "chartbackgroundg";
    public static final String CHARTBACKGROUNDB = "chartbackgroundb";
    public static final String ROLE = "role";
    public static final String CUBE = "cube";
    private static final long serialVersionUID = -327755990995067478L;
    private static final Collection ignoreInputs = Arrays.asList("mode", "query", "query-name", "viewer");

    public Log getLogger() {
        return LogFactory.getLog(PivotViewComponent.class);
    }

    protected boolean validateAction() {
        if (!this.isDefinedOutput(OPTIONS)) {
            this.error(Messages.getInstance().getErrorString("PivotView.ERROR_0001_OPTIONS_NOT_DEFINED"));
            return false;
        }
        if (!this.isDefinedOutput(MODEL)) {
            this.error(Messages.getInstance().getErrorString("PivotView.ERROR_0002_MODEL_NOT_DEFIEND"));
            return false;
        }
        if (!this.isDefinedOutput(CONNECTION)) {
            this.error(Messages.getInstance().getErrorString("PivotView.ERROR_0003_CONNECTION_NOT_DEFINED"));
            return false;
        }
        if (!this.isDefinedOutput("mdx")) {
            this.error(Messages.getInstance().getErrorString("PivotView.ERROR_0004_MDX_NOT_DEFINED"));
            return false;
        }
        if (!this.isDefinedOutput(TITLE)) {
            this.error(Messages.getInstance().getErrorString("PivotView.ERROR_0007_TITLE_NOT_DEFINED"));
            return false;
        }
        if (!this.isDefinedInput(MODE)) {
            this.error(Messages.getInstance().getErrorString("PivotView.ERROR_0005_MODE_NOT_DEFINED"));
            return false;
        }
        if (!this.isDefinedOutput(URL)) {
            this.error(Messages.getInstance().getErrorString("PivotView.ERROR_0008_URL_NOT_DEFINED"));
            return false;
        }
        if (!this.isDefinedInput("query") && !this.isDefinedInput("query-name")) {
            this.error(Messages.getInstance().getErrorString("PivotView.ERROR_0009_QUERY_NOT_DEFINED"));
            return false;
        }
        return true;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public void done() {
    }

    protected boolean executeAction() throws Throwable {
        String cube;
        String query;
        String model;
        Set inputNames = this.getInputNames();
        Set outputNames = this.getOutputNames();
        String mode = this.getInputStringValue(MODE);
        if (!mode.equals(EXECUTE)) {
            if (!this.isDefinedOutput(URL)) {
                this.error(Messages.getInstance().getString("PivotView.ERROR_0006_VIEWER_NOT_DEFINED"));
                return false;
            }
            String viewer = this.getInputStringValue(VIEWER);
            viewer = viewer.indexOf(63) == -1 ? viewer + "?solution=" + this.getSolutionName() + "&path=" + this.getSolutionPath() + "&action=" + this.getActionName() : viewer + "solution=" + this.getSolutionName() + "&path=" + this.getSolutionPath() + "&action=" + this.getActionName();
            for (String name : inputNames) {
                if (ignoreInputs.contains(name)) continue;
                viewer = viewer + "&" + name + "=" + URLEncoder.encode(this.getInputStringValue(name), LocaleHelper.getSystemEncoding());
            }
            this.setOutputValue(URL, PentahoRequestContextHolder.getRequestContext().getContextPath() + viewer);
            return true;
        }
        String roleName = null;
        if (this.isDefinedInput(ROLE)) {
            roleName = this.getInputStringValue(ROLE);
            if (this.isDefinedOutput(ROLE)) {
                this.setOutputValue(ROLE, roleName);
            }
        }
        if (!((model = this.getInputStringValue(MODEL)).startsWith("solution:") || model.startsWith("http:") || model.startsWith("mondrian:"))) {
            model = "solution:" + model;
        }
        this.setOutputValue(MODEL, model);
        if (this.isDefinedOutput(CHARTTYPE) && this.isDefinedInput(CHARTTYPE)) {
            this.setOutputValue(CHARTTYPE, this.getInputStringValue(CHARTTYPE));
        }
        if (this.isDefinedOutput(SHOWGRID) && this.isDefinedInput(SHOWGRID)) {
            this.setOutputValue(SHOWGRID, this.getInputStringValue(SHOWGRID));
        }
        if (this.isDefinedOutput(CHARTLOCATION) && this.isDefinedInput(CHARTLOCATION)) {
            this.setOutputValue(CHARTLOCATION, this.getInputStringValue(CHARTLOCATION));
        }
        if (this.isDefinedOutput(CHARTWIDTH) && this.isDefinedInput(CHARTWIDTH)) {
            this.setOutputValue(CHARTWIDTH, this.getInputStringValue(CHARTWIDTH));
        }
        if (this.isDefinedOutput(CHARTHEIGHT) && this.isDefinedInput(CHARTHEIGHT)) {
            this.setOutputValue(CHARTHEIGHT, this.getInputStringValue(CHARTHEIGHT));
        }
        if (this.isDefinedOutput(CHARTDRILLTHROUGHENABLED) && this.isDefinedInput(CHARTDRILLTHROUGHENABLED)) {
            this.setOutputValue(CHARTDRILLTHROUGHENABLED, this.getInputStringValue(CHARTDRILLTHROUGHENABLED));
        }
        if (this.isDefinedOutput(CHARTTITLE) && this.isDefinedInput(CHARTTITLE)) {
            this.setOutputValue(CHARTTITLE, this.getInputStringValue(CHARTTITLE));
        }
        if (this.isDefinedOutput(CHARTTITLEFONTFAMILY) && this.isDefinedInput(CHARTTITLEFONTFAMILY)) {
            this.setOutputValue(CHARTTITLEFONTFAMILY, this.getInputStringValue(CHARTTITLEFONTFAMILY));
        }
        if (this.isDefinedOutput(CHARTTITLEFONTSTYLE) && this.isDefinedInput(CHARTTITLEFONTSTYLE)) {
            this.setOutputValue(CHARTTITLEFONTSTYLE, this.getInputStringValue(CHARTTITLEFONTSTYLE));
        }
        if (this.isDefinedOutput(CHARTTITLEFONTSIZE) && this.isDefinedInput(CHARTTITLEFONTSIZE)) {
            this.setOutputValue(CHARTTITLEFONTSIZE, this.getInputStringValue(CHARTTITLEFONTSIZE));
        }
        if (this.isDefinedOutput(CHARTHORIZAXISLABEL) && this.isDefinedInput(CHARTHORIZAXISLABEL)) {
            this.setOutputValue(CHARTHORIZAXISLABEL, this.getInputStringValue(CHARTHORIZAXISLABEL));
        }
        if (this.isDefinedOutput(CHARTVERTAXISLABEL) && this.isDefinedInput(CHARTVERTAXISLABEL)) {
            this.setOutputValue(CHARTVERTAXISLABEL, this.getInputStringValue(CHARTVERTAXISLABEL));
        }
        if (this.isDefinedOutput(CHARTAXISLABELFONTFAMILY) && this.isDefinedInput(CHARTAXISLABELFONTFAMILY)) {
            this.setOutputValue(CHARTAXISLABELFONTFAMILY, this.getInputStringValue(CHARTAXISLABELFONTFAMILY));
        }
        if (this.isDefinedOutput(CHARTAXISLABELFONTSTYLE) && this.isDefinedInput(CHARTAXISLABELFONTSTYLE)) {
            this.setOutputValue(CHARTAXISLABELFONTSTYLE, this.getInputStringValue(CHARTAXISLABELFONTSTYLE));
        }
        if (this.isDefinedOutput(CHARTAXISLABELFONTSIZE) && this.isDefinedInput(CHARTAXISLABELFONTSIZE)) {
            this.setOutputValue(CHARTAXISLABELFONTSIZE, this.getInputStringValue(CHARTAXISLABELFONTSIZE));
        }
        if (this.isDefinedOutput(CHARTAXISTICKFONTFAMILY) && this.isDefinedInput(CHARTAXISTICKFONTFAMILY)) {
            this.setOutputValue(CHARTAXISTICKFONTFAMILY, this.getInputStringValue(CHARTAXISTICKFONTFAMILY));
        }
        if (this.isDefinedOutput(CHARTAXISTICKFONTSTYLE) && this.isDefinedInput(CHARTAXISTICKFONTSTYLE)) {
            this.setOutputValue(CHARTAXISTICKFONTSTYLE, this.getInputStringValue(CHARTAXISTICKFONTSTYLE));
        }
        if (this.isDefinedOutput(CHARTAXISTICKFONTSIZE) && this.isDefinedInput(CHARTAXISTICKFONTSIZE)) {
            this.setOutputValue(CHARTAXISTICKFONTSIZE, this.getInputStringValue(CHARTAXISTICKFONTSIZE));
        }
        if (this.isDefinedOutput(CHARTAXISTICKLABELROTATION) && this.isDefinedInput(CHARTAXISTICKLABELROTATION)) {
            this.setOutputValue(CHARTAXISTICKLABELROTATION, this.getInputStringValue(CHARTAXISTICKLABELROTATION));
        }
        if (this.isDefinedOutput(CHARTSHOWLEGEND) && this.isDefinedInput(CHARTSHOWLEGEND)) {
            this.setOutputValue(CHARTSHOWLEGEND, this.getInputStringValue(CHARTSHOWLEGEND));
        }
        if (this.isDefinedOutput(CHARTLEGENDLOCATION) && this.isDefinedInput(CHARTLEGENDLOCATION)) {
            this.setOutputValue(CHARTLEGENDLOCATION, this.getInputStringValue(CHARTLEGENDLOCATION));
        }
        if (this.isDefinedOutput(CHARTLEGENDFONTFAMILY) && this.isDefinedInput(CHARTLEGENDFONTFAMILY)) {
            this.setOutputValue(CHARTLEGENDFONTFAMILY, this.getInputStringValue(CHARTLEGENDFONTFAMILY));
        }
        if (this.isDefinedOutput(CHARTLEGENDFONTSTYLE) && this.isDefinedInput(CHARTLEGENDFONTSTYLE)) {
            this.setOutputValue(CHARTLEGENDFONTSTYLE, this.getInputStringValue(CHARTLEGENDFONTSTYLE));
        }
        if (this.isDefinedOutput(CHARTLEGENDFONTSIZE) && this.isDefinedInput(CHARTLEGENDFONTSIZE)) {
            this.setOutputValue(CHARTLEGENDFONTSIZE, this.getInputStringValue(CHARTLEGENDFONTSIZE));
        }
        if (this.isDefinedOutput(CHARTSHOWSLICER) && this.isDefinedInput(CHARTSHOWSLICER)) {
            this.setOutputValue(CHARTSHOWSLICER, this.getInputStringValue(CHARTSHOWSLICER));
        }
        if (this.isDefinedOutput(CHARTSLICERLOCATION) && this.isDefinedInput(CHARTSLICERLOCATION)) {
            this.setOutputValue(CHARTSLICERLOCATION, this.getInputStringValue(CHARTSLICERLOCATION));
        }
        if (this.isDefinedOutput(CHARTSLICERALIGNMENT) && this.isDefinedInput(CHARTSLICERALIGNMENT)) {
            this.setOutputValue(CHARTSLICERALIGNMENT, this.getInputStringValue(CHARTSLICERALIGNMENT));
        }
        if (this.isDefinedOutput(CHARTSLICERFONTFAMILY) && this.isDefinedInput(CHARTSLICERFONTFAMILY)) {
            this.setOutputValue(CHARTSLICERFONTFAMILY, this.getInputStringValue(CHARTSLICERFONTFAMILY));
        }
        if (this.isDefinedOutput(CHARTSLICERFONTSTYLE) && this.isDefinedInput(CHARTSLICERFONTSTYLE)) {
            this.setOutputValue(CHARTSLICERFONTSTYLE, this.getInputStringValue(CHARTSLICERFONTSTYLE));
        }
        if (this.isDefinedOutput(CHARTSLICERFONTSIZE) && this.isDefinedInput(CHARTSLICERFONTSIZE)) {
            this.setOutputValue(CHARTSLICERFONTSIZE, this.getInputStringValue(CHARTSLICERFONTSIZE));
        }
        if (this.isDefinedOutput(CHARTBACKGROUNDR) && this.isDefinedInput(CHARTBACKGROUNDR)) {
            this.setOutputValue(CHARTBACKGROUNDR, this.getInputStringValue(CHARTBACKGROUNDR));
        }
        if (this.isDefinedOutput(CHARTBACKGROUNDG) && this.isDefinedInput(CHARTBACKGROUNDG)) {
            this.setOutputValue(CHARTBACKGROUNDG, this.getInputStringValue(CHARTBACKGROUNDG));
        }
        if (this.isDefinedOutput(CHARTBACKGROUNDB) && this.isDefinedInput(CHARTBACKGROUNDB)) {
            this.setOutputValue(CHARTBACKGROUNDB, this.getInputStringValue(CHARTBACKGROUNDB));
        }
        String dataSource = this.getInputStringValue("jndi");
        this.setOutputValue(CONNECTION, dataSource);
        String queryName = "query";
        if (inputNames.contains("query-name")) {
            queryName = this.getInputStringValue("query-name");
        }
        if ((query = this.getInputStringValue(queryName)).equals("default") && (query = MondrianModelComponent.getInitialQuery((String)model, (String)dataSource, (String)(cube = this.getInputStringValue(CUBE)), (String)roleName, (IPentahoSession)this.getSession())) == null) {
            this.error(Messages.getInstance().getErrorString("PivotView.ERROR_0010_QUERY_GENERATION_FAILED"));
            return false;
        }
        String mdx = this.applyInputsToFormat(query);
        this.setOutputValue("mdx", mdx);
        String title = this.getInputStringValue(TITLE);
        this.setOutputValue(TITLE, title);
        ArrayList<String> options = new ArrayList<String>();
        Element optionsNode = (Element)this.getComponentDefinition().selectSingleNode(OPTIONS);
        List optionNodes = optionsNode.elements();
        for (Element optionNode : optionNodes) {
            options.add(optionNode.getName());
        }
        if (options.size() > 0) {
            if (outputNames.contains(OPTIONS)) {
                this.setOutputValue(OPTIONS, options);
            } else {
                this.error(Messages.getInstance().getErrorString("PivotView.ERROR_0001_OPTIONS_NOT_DEFINED"));
                return false;
            }
        }
        return true;
    }

    public boolean init() {
        return true;
    }
}

