/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.javafilter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.javafilter.JavaFilterMeta;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JavaFilterDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = JavaFilterMeta.class;
    private Text wStepname;
    private CCombo wTrueTo;
    private CCombo wFalseTo;
    private StyledTextComp wCondition;
    private JavaFilterMeta input;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] colinf;
    private Group wSettingsGroup;
    private FormData fdSettingsGroup;

    public JavaFilterDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (JavaFilterMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaFilterDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JavaFilterDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.wSettingsGroup = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)this.wSettingsGroup);
        this.wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"JavaFIlterDialog.Settings.Label", (String[])new String[0]));
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 10;
        settingsLayout.marginHeight = 10;
        this.wSettingsGroup.setLayout((Layout)settingsLayout);
        Label wlTrueTo = new Label((Composite)this.wSettingsGroup, 131072);
        wlTrueTo.setText(BaseMessages.getString(PKG, (String)"JavaFilterDialog.SendTrueTo.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTrueTo);
        FormData fdlTrueTo = new FormData();
        fdlTrueTo.left = new FormAttachment(0, 0);
        fdlTrueTo.right = new FormAttachment(middle, -margin);
        fdlTrueTo.top = new FormAttachment((Control)this.wStepname, margin);
        wlTrueTo.setLayoutData((Object)fdlTrueTo);
        this.wTrueTo = new CCombo((Composite)this.wSettingsGroup, 2048);
        this.props.setLook((Control)this.wTrueTo);
        StepMeta stepinfo = this.transMeta.findStep(this.stepname);
        if (stepinfo != null) {
            List nextSteps = this.transMeta.findNextSteps(stepinfo);
            for (int i = 0; i < nextSteps.size(); ++i) {
                StepMeta stepMeta = (StepMeta)nextSteps.get(i);
                this.wTrueTo.add(stepMeta.getName());
            }
        }
        this.wTrueTo.addModifyListener(lsMod);
        FormData fdTrueTo = new FormData();
        fdTrueTo.left = new FormAttachment(middle, 0);
        fdTrueTo.top = new FormAttachment((Control)this.wStepname, margin);
        fdTrueTo.right = new FormAttachment(100, 0);
        this.wTrueTo.setLayoutData((Object)fdTrueTo);
        Label wlFalseTo = new Label((Composite)this.wSettingsGroup, 131072);
        wlFalseTo.setText(BaseMessages.getString(PKG, (String)"JavaFilterDialog.SendFalseTo.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFalseTo);
        FormData fdlFalseTo = new FormData();
        fdlFalseTo.left = new FormAttachment(0, 0);
        fdlFalseTo.right = new FormAttachment(middle, -margin);
        fdlFalseTo.top = new FormAttachment((Control)this.wTrueTo, margin);
        wlFalseTo.setLayoutData((Object)fdlFalseTo);
        this.wFalseTo = new CCombo((Composite)this.wSettingsGroup, 2048);
        this.props.setLook((Control)this.wFalseTo);
        stepinfo = this.transMeta.findStep(this.stepname);
        if (stepinfo != null) {
            List nextSteps = this.transMeta.findNextSteps(stepinfo);
            for (int i = 0; i < nextSteps.size(); ++i) {
                StepMeta stepMeta = (StepMeta)nextSteps.get(i);
                this.wFalseTo.add(stepMeta.getName());
            }
        }
        this.wFalseTo.addModifyListener(lsMod);
        FormData fdFalseFrom = new FormData();
        fdFalseFrom.left = new FormAttachment(middle, 0);
        fdFalseFrom.top = new FormAttachment((Control)this.wTrueTo, margin);
        fdFalseFrom.right = new FormAttachment(100, 0);
        this.wFalseTo.setLayoutData((Object)fdFalseFrom);
        Label wlCondition = new Label((Composite)this.wSettingsGroup, 131072);
        wlCondition.setText(BaseMessages.getString(PKG, (String)"JavaFIlterDialog.Condition.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCondition);
        FormData fdlCondition = new FormData();
        fdlCondition.top = new FormAttachment((Control)this.wFalseTo, margin);
        fdlCondition.left = new FormAttachment(0, 0);
        fdlCondition.right = new FormAttachment(middle, -margin);
        wlCondition.setLayoutData((Object)fdlCondition);
        this.wCondition = new StyledTextComp((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, 19202, "");
        this.props.setLook((Control)this.wCondition);
        this.wCondition.addModifyListener(lsMod);
        FormData fdCondition = new FormData();
        fdCondition.top = new FormAttachment((Control)this.wFalseTo, margin);
        fdCondition.left = new FormAttachment(middle, 0);
        fdCondition.right = new FormAttachment(100, 0);
        fdCondition.bottom = new FormAttachment(100, -margin);
        this.wCondition.setLayoutData(fdCondition);
        this.fdSettingsGroup = new FormData();
        this.fdSettingsGroup.left = new FormAttachment(0, margin);
        this.fdSettingsGroup.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdSettingsGroup.right = new FormAttachment(100, -margin);
        this.fdSettingsGroup.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.wSettingsGroup.setLayoutData((Object)this.fdSettingsGroup);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JavaFilterDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JavaFilterDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JavaFilterDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JavaFilterDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        final HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Set keySet = fields.keySet();
                ArrayList entries = new ArrayList(keySet);
                String[] fieldNames = entries.toArray(new String[entries.size()]);
                Const.sortStrings((String[])fieldNames);
                JavaFilterDialog.this.colinf[5].setComboValues(fieldNames);
            }
        });
    }

    public void getData() {
        List targetStreams = this.input.getStepIOMeta().getTargetStreams();
        this.wTrueTo.setText(Const.NVL((String)((StreamInterface)targetStreams.get(0)).getStepname(), (String)""));
        this.wFalseTo.setText(Const.NVL((String)((StreamInterface)targetStreams.get(1)).getStepname(), (String)""));
        this.wCondition.setText(Const.NVL((String)this.input.getCondition(), (String)""));
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        String trueStepname = Const.NVL((String)this.wTrueTo.getText(), null);
        String falseStepname = Const.NVL((String)this.wFalseTo.getText(), null);
        List targetStreams = this.input.getStepIOMeta().getTargetStreams();
        ((StreamInterface)targetStreams.get(0)).setStepMeta(this.transMeta.findStep(trueStepname));
        ((StreamInterface)targetStreams.get(1)).setStepMeta(this.transMeta.findStep(falseStepname));
        this.input.setCondition(this.wCondition.getText());
        this.dispose();
    }
}

