/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.getxmldata;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataField;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataMeta;
import org.pentaho.di.trans.steps.getxmldata.IgnoreDTDEntityResolver;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.xml.sax.EntityResolver;

public class XMLInputFieldsImportProgressDialog {
    private static Class<?> PKG = GetXMLDataMeta.class;
    private static String VALUE_NAME = "Name";
    private static String VALUE_PATH = "Path";
    private static String VALUE_ELEMENT = "Element";
    private static String VALUE_RESULT = "result";
    private static String VALUE_TYPE = "Type";
    private static String VALUE_FORMAT = "Format";
    private Shell shell;
    private GetXMLDataMeta meta;
    private String filename;
    private String encoding;
    private int nr;
    private String loopXPath;
    private HashSet<String> list;
    private List<RowMetaAndData> fieldsList;
    private RowMetaAndData[] fields;
    private String xml;
    private String url;

    public XMLInputFieldsImportProgressDialog(Shell shell, GetXMLDataMeta meta, String filename, String encoding, String loopXPath) {
        this.shell = shell;
        this.meta = meta;
        this.fields = null;
        this.filename = filename;
        this.encoding = encoding;
        this.nr = 0;
        this.loopXPath = loopXPath;
        this.list = new HashSet();
        this.fieldsList = new ArrayList<RowMetaAndData>();
    }

    public XMLInputFieldsImportProgressDialog(Shell shell, GetXMLDataMeta meta, String xmlSource, boolean useUrl, String loopXPath) {
        this.shell = shell;
        this.meta = meta;
        this.fields = null;
        this.filename = null;
        this.encoding = null;
        this.nr = 0;
        this.loopXPath = loopXPath;
        this.list = new HashSet();
        this.fieldsList = new ArrayList<RowMetaAndData>();
        if (useUrl) {
            this.xml = null;
            this.url = xmlSource;
        } else {
            this.xml = xmlSource;
            this.url = null;
        }
    }

    public RowMetaAndData[] open() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    XMLInputFieldsImportProgressDialog.access$002(XMLInputFieldsImportProgressDialog.this, XMLInputFieldsImportProgressDialog.this.doScan(monitor));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Exception.ErrorScanningFile", (String[])new String[]{XMLInputFieldsImportProgressDialog.this.filename, e.toString()}));
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Message", (String[])new String[0]), e);
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Message", (String[])new String[0]), e);
        }
        return this.fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RowMetaAndData[] doScan(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ScanningFile", (String[])new String[]{this.filename}), 1);
        SAXReader reader = new SAXReader();
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return null;
        }
        if (this.meta.isValidating()) {
            reader.setValidation(true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        } else {
            reader.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
        }
        monitor.worked(1);
        monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ReadingDocument", (String[])new String[0]), 1);
        if (monitor.isCanceled()) {
            return null;
        }
        InputStream is = null;
        try {
            Document document = null;
            if (!Const.isEmpty((String)this.filename)) {
                is = KettleVFS.getInputStream((String)this.filename);
                document = reader.read(is, this.encoding);
            } else {
                document = !Const.isEmpty((String)this.xml) ? reader.read((Reader)new StringReader(this.xml)) : reader.read(new URL(this.url));
            }
            monitor.worked(1);
            monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.DocumentOpened", (String[])new String[0]), 1);
            monitor.worked(1);
            monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ReadingNode", (String[])new String[0]), 1);
            if (monitor.isCanceled()) {
                RowMetaAndData[] rowMetaAndDataArray = null;
                return rowMetaAndDataArray;
            }
            List nodes = document.selectNodes(this.loopXPath);
            monitor.worked(1);
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[0]));
            if (monitor.isCanceled()) {
                RowMetaAndData[] e = null;
                return e;
            }
            for (Node node : nodes) {
                if (monitor.isCanceled()) {
                    RowMetaAndData[] rowMetaAndDataArray = null;
                    return rowMetaAndDataArray;
                }
                ++this.nr;
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[]{String.valueOf(this.nr)}));
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[]{node.getPath()}));
                this.setNodeField(node, monitor);
                this.childNode(node, monitor);
            }
            monitor.worked(1);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
        RowMetaAndData[] listFields = this.fieldsList.toArray(new RowMetaAndData[this.fieldsList.size()]);
        monitor.setTaskName(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.NodesReturned", (String[])new String[0]));
        monitor.done();
        return listFields;
    }

    private void setNodeField(Node node, IProgressMonitor monitor) {
        Element e = (Element)node;
        List lista = e.attributes();
        for (int i = 0; i < lista.size(); ++i) {
            this.setAttributeField((Attribute)lista.get(i), monitor);
        }
        String nodename = node.getName();
        String nodenametxt = this.cleanString(node.getPath());
        if (!Const.isEmpty((String)nodenametxt) && !this.list.contains(nodenametxt)) {
            ++this.nr;
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDataXMLInputFieldsImportProgressDialog.Task.FetchFields", (String[])new String[]{String.valueOf(this.nr)}));
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDataXMLInputFieldsImportProgressDialog.Task.AddingField", (String[])new String[]{nodename}));
            RowMetaAndData row = new RowMetaAndData();
            row.addValue(VALUE_NAME, 2, (Object)nodename);
            row.addValue(VALUE_PATH, 2, (Object)nodenametxt);
            row.addValue(VALUE_ELEMENT, 2, (Object)GetXMLDataField.ElementTypeDesc[0]);
            row.addValue(VALUE_RESULT, 2, (Object)GetXMLDataField.ResultTypeDesc[0]);
            String valueNode = node.getText();
            if (this.IsDate(valueNode)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Date");
                row.addValue(VALUE_FORMAT, 2, (Object)"yyyy/MM/dd");
            } else if (this.IsInteger(valueNode)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Integer");
                row.addValue(VALUE_FORMAT, 2, null);
            } else if (this.IsNumber(valueNode)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Number");
                row.addValue(VALUE_FORMAT, 2, null);
            } else {
                row.addValue(VALUE_TYPE, 2, (Object)"String");
                row.addValue(VALUE_FORMAT, 2, null);
            }
            this.fieldsList.add(row);
            this.list.add(nodenametxt);
        }
    }

    private void setAttributeField(Attribute attribute, IProgressMonitor monitor) {
        String attributname = attribute.getName();
        String attributnametxt = this.cleanString(attribute.getPath());
        if (!Const.isEmpty((String)attributnametxt) && !this.list.contains(attribute.getPath())) {
            ++this.nr;
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDataXMLInputFieldsImportProgressDialog.Task.FetchFields", (String[])new String[]{String.valueOf(this.nr)}));
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDataXMLInputFieldsImportProgressDialog.Task.AddingField", (String[])new String[]{attributname}));
            RowMetaAndData row = new RowMetaAndData();
            row.addValue(VALUE_NAME, 2, (Object)attributname);
            row.addValue(VALUE_PATH, 2, (Object)attributnametxt);
            row.addValue(VALUE_ELEMENT, 2, (Object)GetXMLDataField.ElementTypeDesc[1]);
            row.addValue(VALUE_RESULT, 2, (Object)GetXMLDataField.ResultTypeDesc[0]);
            String valueAttr = attribute.getText();
            if (this.IsDate(valueAttr)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Date");
                row.addValue(VALUE_FORMAT, 2, (Object)"yyyy/MM/dd");
            } else if (this.IsInteger(valueAttr)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Integer");
                row.addValue(VALUE_FORMAT, 2, null);
            } else if (this.IsNumber(valueAttr)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Number");
                row.addValue(VALUE_FORMAT, 2, null);
            } else {
                row.addValue(VALUE_TYPE, 2, (Object)"String");
                row.addValue(VALUE_FORMAT, 2, null);
            }
            this.list.add(attribute.getPath());
        }
    }

    private String cleanString(String inputstring) {
        String retval = inputstring;
        retval = retval.replace(this.loopXPath, "");
        while (retval.startsWith("/")) {
            retval = retval.substring(1, retval.length());
        }
        return retval;
    }

    private boolean IsDate(String str) {
        try {
            SimpleDateFormat fdate = new SimpleDateFormat("yyyy/MM/dd");
            fdate.setLenient(false);
            fdate.parse(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean IsInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean IsNumber(String str) {
        try {
            Float.parseFloat(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean childNode(Node node, IProgressMonitor monitor) {
        boolean rc = false;
        Element ce = (Element)node;
        for (int j = 0; j < ce.nodeCount(); ++j) {
            Node cnode = ce.node(j);
            if (Const.isEmpty((String)cnode.getName())) continue;
            Element cce = (Element)cnode;
            if (cce.nodeCount() > 1) {
                if (this.childNode(cnode, monitor)) continue;
                this.setNodeField(cnode, monitor);
                rc = true;
                continue;
            }
            this.setNodeField(cnode, monitor);
            rc = true;
        }
        return rc;
    }

    static /* synthetic */ RowMetaAndData[] access$002(XMLInputFieldsImportProgressDialog x0, RowMetaAndData[] x1) {
        x0.fields = x1;
        return x1;
    }
}

