/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.getxmldata;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataMeta;
import org.pentaho.di.trans.steps.getxmldata.IgnoreDTDEntityResolver;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.xml.sax.EntityResolver;

public class LoopNodesImportProgressDialog {
    private static Class<?> PKG = GetXMLDataMeta.class;
    private Shell shell;
    private GetXMLDataMeta meta;
    private String[] Xpaths;
    private String filename;
    private String xml;
    private String url;
    private String encoding;
    private ArrayList<String> listpath;
    private int nr;

    public LoopNodesImportProgressDialog(Shell shell, GetXMLDataMeta meta, String filename, String encoding) {
        this.shell = shell;
        this.meta = meta;
        this.Xpaths = null;
        this.filename = filename;
        this.encoding = encoding;
        this.listpath = new ArrayList();
        this.nr = 0;
        this.xml = null;
        this.url = null;
    }

    public LoopNodesImportProgressDialog(Shell shell, GetXMLDataMeta meta, String xmlSource, boolean useUrl) {
        this.shell = shell;
        this.meta = meta;
        this.Xpaths = null;
        this.filename = null;
        this.encoding = null;
        this.listpath = new ArrayList();
        this.nr = 0;
        if (useUrl) {
            this.xml = null;
            this.url = xmlSource;
        } else {
            this.xml = xmlSource;
            this.url = null;
        }
    }

    public String[] open() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    LoopNodesImportProgressDialog.access$002(LoopNodesImportProgressDialog.this, LoopNodesImportProgressDialog.this.doScan(monitor));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Exception.ErrorScanningFile", (String[])new String[]{LoopNodesImportProgressDialog.this.filename, e.toString()}));
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Message", (String[])new String[0]), e);
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Message", (String[])new String[0]), e);
        }
        return this.Xpaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] doScan(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ScanningFile", (String[])new String[]{this.filename}), 1);
        SAXReader reader = new SAXReader();
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return null;
        }
        if (this.meta.isValidating()) {
            reader.setValidation(true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        } else {
            reader.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
        }
        monitor.worked(1);
        monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ReadingDocument", (String[])new String[0]), 1);
        if (monitor.isCanceled()) {
            return null;
        }
        InputStream is = null;
        try {
            Document document = null;
            if (!Const.isEmpty((String)this.filename)) {
                is = KettleVFS.getInputStream((String)this.filename);
                document = reader.read(is, this.encoding);
            } else {
                document = !Const.isEmpty((String)this.xml) ? reader.read((Reader)new StringReader(this.xml)) : reader.read(new URL(this.url));
            }
            monitor.worked(1);
            monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.DocumentOpened", (String[])new String[0]), 1);
            monitor.worked(1);
            monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ReadingNode", (String[])new String[0]), 1);
            if (monitor.isCanceled()) {
                String[] stringArray = null;
                return stringArray;
            }
            List nodes = document.selectNodes(document.getRootElement().getName());
            monitor.worked(1);
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[0]));
            if (monitor.isCanceled()) {
                String[] e = null;
                return e;
            }
            for (Node node : nodes) {
                if (monitor.isCanceled()) {
                    String[] stringArray = null;
                    return stringArray;
                }
                if (this.listpath.contains(node.getPath())) continue;
                ++this.nr;
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[]{String.valueOf(this.nr)}));
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.AddingNode", (String[])new String[]{node.getPath()}));
                this.listpath.add(node.getPath());
                this.addLoopXPath(node, monitor);
            }
            monitor.worked(1);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
        String[] list_xpath = this.listpath.toArray(new String[this.listpath.size()]);
        monitor.setTaskName(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.NodesReturned", (String[])new String[0]));
        monitor.done();
        return list_xpath;
    }

    private void addLoopXPath(Node node, IProgressMonitor monitor) {
        Element ce = (Element)node;
        monitor.worked(1);
        for (int j = 0; j < ce.nodeCount(); ++j) {
            if (monitor.isCanceled()) {
                return;
            }
            Node cnode = ce.node(j);
            if (Const.isEmpty((String)cnode.getName())) continue;
            Element cce = (Element)cnode;
            if (!this.listpath.contains(cnode.getPath())) {
                ++this.nr;
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[]{String.valueOf(this.nr)}));
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.AddingNode", (String[])new String[]{cnode.getPath()}));
                this.listpath.add(cnode.getPath());
            }
            if (cce.nodeCount() <= 1) continue;
            this.addLoopXPath(cnode, monitor);
        }
    }

    static /* synthetic */ String[] access$002(LoopNodesImportProgressDialog x0, String[] x1) {
        x0.Xpaths = x1;
        return x1;
    }
}

