/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.blockingstep;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.blockingstep.BlockingStepMeta;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class BlockingStepDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = BlockingStepMeta.class;
    private BlockingStepMeta input;
    private Label wlPassAllRows;
    private Button wPassAllRows;
    private Label wlSpoolDir;
    private Button wbSpoolDir;
    private TextVar wSpoolDir;
    private FormData fdlSpoolDir;
    private FormData fdbSpoolDir;
    private FormData fdSpoolDir;
    private Label wlPrefix;
    private Text wPrefix;
    private FormData fdlPrefix;
    private FormData fdPrefix;
    private Label wlCacheSize;
    private Text wCacheSize;
    private FormData fdlCacheSize;
    private FormData fdCacheSize;
    private Label wlCompress;
    private Button wCompress;
    private FormData fdlCompress;
    private FormData fdCompress;

    public BlockingStepDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (BlockingStepMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BlockingStepDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BlockingStepDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"BlockingStepDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlPassAllRows = new Label((Composite)this.shell, 131072);
        this.wlPassAllRows.setText(BaseMessages.getString(PKG, (String)"BlockingStepDialog.PassAllRows.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPassAllRows);
        FormData fdlUpdate = new FormData();
        fdlUpdate.left = new FormAttachment(0, 0);
        fdlUpdate.right = new FormAttachment(middle, -margin);
        fdlUpdate.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlPassAllRows.setLayoutData((Object)fdlUpdate);
        this.wPassAllRows = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wPassAllRows);
        FormData fdUpdate = new FormData();
        fdUpdate.left = new FormAttachment(middle, 0);
        fdUpdate.top = new FormAttachment((Control)this.wStepname, margin);
        fdUpdate.right = new FormAttachment(100, 0);
        this.wPassAllRows.setLayoutData((Object)fdUpdate);
        this.wPassAllRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BlockingStepDialog.this.input.setChanged();
                BlockingStepDialog.this.setEnableDialog();
            }
        });
        this.wlSpoolDir = new Label((Composite)this.shell, 131072);
        this.wlSpoolDir.setText(BaseMessages.getString(PKG, (String)"BlockingStepDialog.SpoolDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSpoolDir);
        this.fdlSpoolDir = new FormData();
        this.fdlSpoolDir.left = new FormAttachment(0, 0);
        this.fdlSpoolDir.right = new FormAttachment(middle, -margin);
        this.fdlSpoolDir.top = new FormAttachment((Control)this.wPassAllRows, margin);
        this.wlSpoolDir.setLayoutData((Object)this.fdlSpoolDir);
        this.wbSpoolDir = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbSpoolDir);
        this.wbSpoolDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbSpoolDir = new FormData();
        this.fdbSpoolDir.right = new FormAttachment(100, 0);
        this.fdbSpoolDir.top = new FormAttachment((Control)this.wPassAllRows, margin);
        this.wbSpoolDir.setLayoutData((Object)this.fdbSpoolDir);
        this.wSpoolDir = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSpoolDir);
        this.wSpoolDir.addModifyListener(lsMod);
        this.fdSpoolDir = new FormData();
        this.fdSpoolDir.left = new FormAttachment(middle, 0);
        this.fdSpoolDir.top = new FormAttachment((Control)this.wPassAllRows, margin);
        this.fdSpoolDir.right = new FormAttachment((Control)this.wbSpoolDir, -margin);
        this.wSpoolDir.setLayoutData(this.fdSpoolDir);
        this.wbSpoolDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DirectoryDialog dd = new DirectoryDialog(BlockingStepDialog.this.shell, 0);
                dd.setFilterPath(BlockingStepDialog.this.wSpoolDir.getText());
                String dir = dd.open();
                if (dir != null) {
                    BlockingStepDialog.this.wSpoolDir.setText(dir);
                }
            }
        });
        this.wSpoolDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BlockingStepDialog.this.wSpoolDir.setToolTipText(BlockingStepDialog.this.transMeta.environmentSubstitute(BlockingStepDialog.this.wSpoolDir.getText()));
            }
        });
        this.wlPrefix = new Label((Composite)this.shell, 131072);
        this.wlPrefix.setText(BaseMessages.getString(PKG, (String)"BlockingStepDialog.Prefix.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPrefix);
        this.fdlPrefix = new FormData();
        this.fdlPrefix.left = new FormAttachment(0, 0);
        this.fdlPrefix.right = new FormAttachment(middle, -margin);
        this.fdlPrefix.top = new FormAttachment((Control)this.wbSpoolDir, margin * 2);
        this.wlPrefix.setLayoutData((Object)this.fdlPrefix);
        this.wPrefix = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPrefix);
        this.wPrefix.addModifyListener(lsMod);
        this.fdPrefix = new FormData();
        this.fdPrefix.left = new FormAttachment(middle, 0);
        this.fdPrefix.top = new FormAttachment((Control)this.wbSpoolDir, margin * 2);
        this.fdPrefix.right = new FormAttachment(100, 0);
        this.wPrefix.setLayoutData((Object)this.fdPrefix);
        this.wlCacheSize = new Label((Composite)this.shell, 131072);
        this.wlCacheSize.setText(BaseMessages.getString(PKG, (String)"BlockingStepDialog.CacheSize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCacheSize);
        this.fdlCacheSize = new FormData();
        this.fdlCacheSize.left = new FormAttachment(0, 0);
        this.fdlCacheSize.right = new FormAttachment(middle, -margin);
        this.fdlCacheSize.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        this.wlCacheSize.setLayoutData((Object)this.fdlCacheSize);
        this.wCacheSize = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCacheSize);
        this.wCacheSize.addModifyListener(lsMod);
        this.fdCacheSize = new FormData();
        this.fdCacheSize.left = new FormAttachment(middle, 0);
        this.fdCacheSize.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        this.fdCacheSize.right = new FormAttachment(100, 0);
        this.wCacheSize.setLayoutData((Object)this.fdCacheSize);
        this.wlCompress = new Label((Composite)this.shell, 131072);
        this.wlCompress.setText(BaseMessages.getString(PKG, (String)"BlockingStepDialog.Compress.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCompress);
        this.fdlCompress = new FormData();
        this.fdlCompress.left = new FormAttachment(0, 0);
        this.fdlCompress.right = new FormAttachment(middle, -margin);
        this.fdlCompress.top = new FormAttachment((Control)this.wCacheSize, margin * 2);
        this.wlCompress.setLayoutData((Object)this.fdlCompress);
        this.wCompress = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wCompress);
        this.fdCompress = new FormData();
        this.fdCompress.left = new FormAttachment(middle, 0);
        this.fdCompress.top = new FormAttachment((Control)this.wCacheSize, margin * 2);
        this.fdCompress.right = new FormAttachment(100, 0);
        this.wCompress.setLayoutData((Object)this.fdCompress);
        this.wCompress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BlockingStepDialog.this.input.setChanged();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wCompress);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                BlockingStepDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                BlockingStepDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                BlockingStepDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                BlockingStepDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.setEnableDialog();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        this.wPassAllRows.setSelection(this.input.isPassAllRows());
        if (this.input.getPrefix() != null) {
            this.wPrefix.setText(this.input.getPrefix());
        }
        if (this.input.getDirectory() != null) {
            this.wSpoolDir.setText(this.input.getDirectory());
        }
        this.wCacheSize.setText("" + this.input.getCacheSize());
        this.wCompress.setSelection(this.input.getCompress());
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.input.setPrefix(this.wPrefix.getText());
        this.input.setDirectory(this.wSpoolDir.getText());
        this.input.setCacheSize(Const.toInt((String)this.wCacheSize.getText(), (int)5000));
        if (this.isDetailed()) {
            this.logDetailed("Compression is set to " + this.wCompress.getSelection());
        }
        this.input.setCompress(this.wCompress.getSelection());
        this.input.setPassAllRows(this.wPassAllRows.getSelection());
        this.dispose();
    }

    private void setEnableDialog() {
        this.wlSpoolDir.setEnabled(this.wPassAllRows.getSelection());
        this.wbSpoolDir.setEnabled(this.wPassAllRows.getSelection());
        this.wSpoolDir.setEnabled(this.wPassAllRows.getSelection());
        this.wlPrefix.setEnabled(this.wPassAllRows.getSelection());
        this.wPrefix.setEnabled(this.wPassAllRows.getSelection());
        this.wlCacheSize.setEnabled(this.wPassAllRows.getSelection());
        this.wCacheSize.setEnabled(this.wPassAllRows.getSelection());
        this.wlCompress.setEnabled(this.wPassAllRows.getSelection());
        this.wCompress.setEnabled(this.wPassAllRows.getSelection());
    }
}

