/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.trans;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.ui.spoon.trans.DelayListener;

public class DelayTimer
implements Runnable {
    private int delayInMiliseconds;
    private boolean stopped;
    private List<DelayListener> delayListeners;
    private long start;

    public DelayTimer(int delayInMiliseconds) {
        this.delayInMiliseconds = delayInMiliseconds;
        this.delayListeners = new ArrayList<DelayListener>();
        this.stopped = false;
    }

    public DelayTimer(int delayInMilliseconds, DelayListener delayListener) {
        this(delayInMilliseconds);
        this.addDelayListener(delayListener);
    }

    public void reset() {
        this.start = System.currentTimeMillis();
    }

    @Override
    public void run() {
        this.reset();
        while (System.currentTimeMillis() - this.start < (long)this.delayInMiliseconds && !this.stopped) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        for (DelayListener delayListener : this.delayListeners) {
            delayListener.expired();
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public void addDelayListener(DelayListener delayListener) {
        this.delayListeners.add(delayListener);
    }

    public int getDelayInMilliseconds() {
        return this.delayInMiliseconds;
    }

    public void setDelayInSeconds(int delayInMilliseconds) {
        this.delayInMiliseconds = delayInMilliseconds;
    }
}

