/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.partition;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepPartitioningMeta;

public class PartitionSettings {
    private StepMeta stepMeta;
    private TransMeta transMeta;
    private String[] options;
    private String[] codes;
    private String[] schemaNames;
    private StepMeta before;
    private StepMeta after;

    public PartitionSettings(int exactSize, TransMeta transMeta, StepMeta stepMeta) {
        this.transMeta = transMeta;
        this.stepMeta = stepMeta;
        this.schemaNames = this.transMeta.getPartitionSchemasNames();
        this.options = new String[exactSize];
        this.codes = new String[exactSize];
        this.before = (StepMeta)stepMeta.clone();
        System.arraycopy(StepPartitioningMeta.methodDescriptions, 0, this.options, 0, StepPartitioningMeta.methodDescriptions.length);
        System.arraycopy(StepPartitioningMeta.methodCodes, 0, this.codes, 0, StepPartitioningMeta.methodCodes.length);
    }

    public void fillOptionsAndCodesByPlugins(List<PluginInterface> plugins) {
        int pluginIndex = 0;
        for (PluginInterface plugin : plugins) {
            this.options[StepPartitioningMeta.methodDescriptions.length + pluginIndex] = plugin.getDescription();
            this.codes[StepPartitioningMeta.methodCodes.length + pluginIndex] = plugin.getIds()[0];
            ++pluginIndex;
        }
    }

    public int getDefaultSelectedMethodIndex() {
        for (int i = 0; i < this.codes.length; ++i) {
            if (!this.codes[i].equals(this.stepMeta.getStepPartitioningMeta().getMethod())) continue;
            return i;
        }
        return 0;
    }

    public int getDefaultSelectedSchemaIndex() {
        int defaultSelectedSchemaIndex = 0;
        if (this.stepMeta.getStepPartitioningMeta().getPartitionSchema() != null && this.schemaNames.length > 0) {
            defaultSelectedSchemaIndex = Const.indexOfString((String)this.stepMeta.getStepPartitioningMeta().getPartitionSchema().getName(), (String[])this.schemaNames);
        }
        return defaultSelectedSchemaIndex != -1 ? defaultSelectedSchemaIndex : 0;
    }

    public String getMethodByMethodDescription(String methodDescription) {
        String method = StepPartitioningMeta.methodCodes[0];
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].equals(methodDescription)) continue;
            method = this.codes[i];
        }
        return method;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void setOptions(String[] options) {
        this.options = options;
    }

    public String[] getCodes() {
        return this.codes;
    }

    public void setCodes(String[] codes) {
        this.codes = codes;
    }

    public String[] getSchemaNames() {
        return this.schemaNames;
    }

    public void setSchemaNames(String[] schemaNames) {
        this.schemaNames = schemaNames;
    }

    public StepMeta getStepMeta() {
        return this.stepMeta;
    }

    public void updateMethodType(int methodType) {
        this.stepMeta.getStepPartitioningMeta().setMethodType(methodType);
    }

    public void updateMethod(String method) throws KettlePluginException {
        this.stepMeta.getStepPartitioningMeta().setMethod(method);
    }

    public void updateSchema(PartitionSchema schema) {
        if (schema != null && schema.getName() != null) {
            this.stepMeta.getStepPartitioningMeta().setPartitionSchema(schema);
        }
    }

    public void rollback(StepMeta before) throws KettlePluginException {
        this.updateMethod(before.getStepPartitioningMeta().getMethod());
        this.updateMethodType(before.getStepPartitioningMeta().getMethodType());
        this.updateSchema(before.getStepPartitioningMeta().getPartitionSchema());
    }

    public StepMeta getBefore() {
        return this.before;
    }

    public StepMeta getAfter() {
        return (StepMeta)this.stepMeta.clone();
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }
}

