/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.job;

import java.util.ArrayList;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.spoon.trans.LogBrowser;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.impl.XulEventHandler;

public class JobLogDelegate
extends SpoonDelegate
implements XulEventHandler {
    private static Class<?> PKG = JobGraph.class;
    private static final String XUL_FILE_TRANS_LOG_TOOLBAR = "ui/job-log-toolbar.xul";
    private JobGraph jobGraph;
    private CTabItem jobLogTab;
    public StyledText jobLogText;
    private Composite jobLogComposite;
    private XulToolbar toolbar;
    private LogBrowser logBrowser;

    public JobLogDelegate(Spoon spoon, JobGraph jobGraph) {
        super(spoon);
        this.jobGraph = jobGraph;
    }

    public void addJobLog() {
        if (this.jobGraph.extraViewComposite == null || this.jobGraph.extraViewComposite.isDisposed()) {
            this.jobGraph.addExtraView();
        } else if (this.jobLogTab != null && !this.jobLogTab.isDisposed()) {
            this.jobGraph.extraViewTabFolder.setSelection(this.jobLogTab);
            return;
        }
        this.jobLogTab = new CTabItem(this.jobGraph.extraViewTabFolder, 0);
        this.jobLogTab.setImage(GUIResource.getInstance().getImageShowLog());
        this.jobLogTab.setText(BaseMessages.getString(PKG, (String)"JobGraph.LogTab.Name", (String[])new String[0]));
        this.jobLogComposite = new Composite((Composite)this.jobGraph.extraViewTabFolder, 0);
        this.jobLogComposite.setLayout((Layout)new FormLayout());
        this.addToolBar();
        Control toolbarControl = (Control)this.toolbar.getManagedObject();
        this.spoon.props.setLook(toolbarControl);
        toolbarControl.setLayoutData((Object)new FormData());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        toolbarControl.setLayoutData((Object)fd);
        toolbarControl.setParent(this.jobLogComposite);
        this.jobLogText = new StyledText(this.jobLogComposite, 778);
        this.spoon.props.setLook((Control)this.jobLogText);
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment((Control)this.toolbar.getManagedObject(), 0);
        fdText.bottom = new FormAttachment(100, 0);
        this.jobLogText.setLayoutData((Object)fdText);
        this.logBrowser = new LogBrowser(this.jobLogText, this.jobGraph);
        this.logBrowser.installLogSniffer();
        this.jobGraph.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (((JobLogDelegate)JobLogDelegate.this).jobGraph.job != null) {
                    KettleLogStore.discardLines((String)((JobLogDelegate)JobLogDelegate.this).jobGraph.job.getLogChannelId(), (boolean)true);
                }
            }
        });
        this.jobLogTab.setControl((Control)this.jobLogComposite);
        this.jobGraph.extraViewTabFolder.setSelection(this.jobLogTab);
    }

    private void addToolBar() {
        try {
            KettleXulLoader loader = new KettleXulLoader();
            loader.setSettingsManager(XulSpoonSettingsManager.getInstance());
            XulSpoonResourceBundle bundle = new XulSpoonResourceBundle(Spoon.class);
            XulDomContainer xulDomContainer = loader.loadXul(XUL_FILE_TRANS_LOG_TOOLBAR, bundle);
            xulDomContainer.addEventHandler((XulEventHandler)this);
            this.toolbar = (XulToolbar)xulDomContainer.getDocumentRoot().getElementById("nav-toolbar");
            ToolBar swtToolbar = (ToolBar)this.toolbar.getManagedObject();
            swtToolbar.layout(true, true);
        }
        catch (Throwable t) {
            this.log.logError(Const.getStackTracker((Throwable)t));
            new ErrorDialog(this.jobLogComposite.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Message", (String[])new String[]{XUL_FILE_TRANS_LOG_TOOLBAR}), new Exception(t));
        }
    }

    public void clearLog() {
        if (this.jobLogText != null && !this.jobLogText.isDisposed()) {
            this.jobLogText.setText("");
        }
    }

    public void showLogSettings() {
        this.spoon.setLog();
    }

    public void showErrors() {
        int i;
        String all = this.jobLogText.getText();
        ArrayList<String> err = new ArrayList<String>();
        int startpos = 0;
        int crlen = Const.CR.length();
        String line = null;
        String lineUpper = null;
        for (i = 0; i < all.length() - crlen; ++i) {
            if (!all.substring(i, i + crlen).equalsIgnoreCase(Const.CR)) continue;
            line = all.substring(startpos, i);
            lineUpper = line.toUpperCase();
            if (lineUpper.indexOf(BaseMessages.getString(PKG, (String)"JobLog.System.ERROR", (String[])new String[0])) >= 0 || lineUpper.indexOf(BaseMessages.getString(PKG, (String)"JobLog.System.EXCEPTION", (String[])new String[0])) >= 0) {
                err.add(line);
            }
            startpos = i + crlen;
        }
        line = all.substring(startpos);
        lineUpper = line.toUpperCase();
        if (lineUpper.indexOf(BaseMessages.getString(PKG, (String)"JobLog.System.ERROR", (String[])new String[0])) >= 0 || lineUpper.indexOf(BaseMessages.getString(PKG, (String)"JobLog.System.EXCEPTION", (String[])new String[0])) >= 0) {
            err.add(line);
        }
        if (err.size() > 0) {
            String[] err_lines = new String[err.size()];
            for (i = 0; i < err_lines.length; ++i) {
                err_lines[i] = (String)err.get(i);
            }
            EnterSelectionDialog esd = new EnterSelectionDialog(this.jobGraph.getShell(), err_lines, BaseMessages.getString(PKG, (String)"JobLog.Dialog.ErrorLines.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLog.Dialog.ErrorLines.Message", (String[])new String[0]));
            line = esd.open();
            if (line != null) {
                JobMeta jobMeta = this.jobGraph.getManagedObject();
                for (i = 0; i < jobMeta.nrJobEntries(); ++i) {
                    JobEntryCopy entryCopy = jobMeta.getJobEntry(i);
                    if (line.indexOf(entryCopy.getName()) < 0) continue;
                    this.spoon.editJobEntry(jobMeta, entryCopy);
                }
            }
        }
    }

    public CTabItem getJobLogTab() {
        return this.jobLogTab;
    }

    public void pauseLog() {
        XulToolbarbutton pauseContinueButton = (XulToolbarbutton)this.toolbar.getElementById("log-pause");
        ToolItem swtToolItem = (ToolItem)pauseContinueButton.getManagedObject();
        if (this.logBrowser.isPaused()) {
            this.logBrowser.setPaused(false);
            if (pauseContinueButton != null) {
                swtToolItem.setImage(GUIResource.getInstance().getImagePauseLog());
            }
        } else {
            this.logBrowser.setPaused(true);
            if (pauseContinueButton != null) {
                swtToolItem.setImage(GUIResource.getInstance().getImageContinueLog());
            }
        }
    }

    public Object getData() {
        return null;
    }

    public String getName() {
        return "joblog";
    }

    public XulDomContainer getXulDomContainer() {
        return null;
    }

    public void setData(Object data) {
    }

    public void setName(String name) {
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
    }
}

