/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.trans.HasSlaveServersInterface;
import org.pentaho.di.ui.cluster.dialog.SlaveServerDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonSlave;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.xul.swt.tab.TabItem;
import org.pentaho.xul.swt.tab.TabSet;

public class SpoonSlaveDelegate
extends SpoonDelegate {
    private static Class<?> PKG = Spoon.class;

    public SpoonSlaveDelegate(Spoon spoon) {
        super(spoon);
    }

    public void addSpoonSlave(SlaveServer slaveServer) {
        TabSet tabfolder = this.spoon.tabfolder;
        String tabName = this.spoon.delegates.tabs.makeSlaveTabName(slaveServer);
        TabMapEntry tabMapEntry = this.spoon.delegates.tabs.findTabMapEntry(tabName, TabMapEntry.ObjectType.SLAVE_SERVER);
        if (tabMapEntry == null) {
            SpoonSlave spoonSlave = new SpoonSlave((Composite)tabfolder.getSwtTabset(), 0, this.spoon, slaveServer);
            TabItem tabItem = new TabItem(tabfolder, tabName, tabName);
            tabItem.setToolTipText("Status of slave server : " + slaveServer.getName() + " : " + slaveServer.getServerAndPort());
            tabItem.setControl((Control)spoonSlave);
            tabMapEntry = new TabMapEntry(tabItem, null, tabName, null, null, spoonSlave, TabMapEntry.ObjectType.SLAVE_SERVER);
            this.spoon.delegates.tabs.addTab(tabMapEntry);
        }
        int idx = tabfolder.indexOf(tabMapEntry.getTabItem());
        tabfolder.setSelected(idx);
    }

    public void delSlaveServer(HasSlaveServersInterface hasSlaveServersInterface, SlaveServer slaveServer) throws KettleException {
        Repository rep = this.spoon.getRepository();
        if (rep != null && slaveServer.getObjectId() != null) {
            rep.deleteSlave(slaveServer.getObjectId());
        }
        int idx = hasSlaveServersInterface.getSlaveServers().indexOf(slaveServer);
        hasSlaveServersInterface.getSlaveServers().remove(idx);
        this.spoon.refreshTree();
    }

    public void newSlaveServer(HasSlaveServersInterface hasSlaveServersInterface) {
        SlaveServer slaveServer = new SlaveServer();
        SlaveServerDialog dialog = new SlaveServerDialog(this.spoon.getShell(), slaveServer);
        if (dialog.open()) {
            hasSlaveServersInterface.getSlaveServers().add(slaveServer);
            if (this.spoon.rep != null) {
                try {
                    if (this.spoon.rep.getSecurityProvider().isReadOnly()) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Spoon.Dialog.Exception.ReadOnlyRepositoryUser", (String[])new String[0]));
                    }
                    this.spoon.rep.save((RepositoryElementInterface)slaveServer, "Creation of initial version", null);
                }
                catch (KettleException e) {
                    new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingSlave.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingSlave.Message", (String[])new String[]{slaveServer.getName()}), (Exception)((Object)e));
                }
            }
            this.spoon.refreshTree();
        }
    }
}

