/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeListener;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonLifecycleListener;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.di.ui.spoon.SpoonPluginCategories;
import org.pentaho.di.ui.spoon.SpoonPluginInterface;
import org.pentaho.di.ui.spoon.SpoonPluginType;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;

public class SpoonPluginManager {
    private static SpoonPluginManager instance = new SpoonPluginManager();
    private List<SpoonPluginInterface> plugins = new ArrayList<SpoonPluginInterface>();
    private Map<String, List<SpoonPluginInterface>> pluginCategoryMap = new HashMap<String, List<SpoonPluginInterface>>();

    private SpoonPluginManager() {
        List plugins = PluginRegistry.getInstance().getPlugins(SpoonPluginType.class);
        for (PluginInterface plug : plugins) {
            try {
                this.loadPlugin((SpoonPluginInterface)PluginRegistry.getInstance().loadClass(plug));
            }
            catch (KettlePluginException e) {
                e.printStackTrace();
            }
        }
    }

    private SpoonPluginInterface loadPlugin(SpoonPluginInterface sp) {
        if (this.plugins.contains(sp)) {
            return null;
        }
        SpoonPluginCategories categories = sp.getClass().getAnnotation(SpoonPluginCategories.class);
        if (categories != null) {
            for (String cat : categories.value()) {
                List<SpoonPluginInterface> categoryList = this.pluginCategoryMap.get(cat);
                if (categoryList == null) {
                    categoryList = new ArrayList<SpoonPluginInterface>();
                    this.pluginCategoryMap.put(cat, categoryList);
                }
                categoryList.add(sp);
            }
        }
        if (sp.getPerspective() != null) {
            SpoonPerspectiveManager.getInstance().addPerspective(sp.getPerspective());
        }
        this.plugins.add(sp);
        return sp;
    }

    protected SpoonPluginInterface removePlugin(SpoonPluginInterface sp) {
        if (sp.getPerspective() != null) {
            SpoonPerspectiveManager.getInstance().removePerspective(sp.getPerspective());
        }
        this.plugins.remove(sp);
        return sp;
    }

    public static SpoonPluginManager getInstance() {
        return instance;
    }

    public void applyPluginsForContainer(final String category, final XulDomContainer container) throws XulException {
        List<SpoonPluginInterface> plugins = this.pluginCategoryMap.get(category);
        if (plugins != null) {
            for (SpoonPluginInterface sp : plugins) {
                sp.applyToContainer(category, container);
            }
        }
        PluginRegistry.getInstance().addPluginListener(SpoonPluginType.class, new PluginTypeListener(){

            public void pluginAdded(final Object serviceObject) {
                ((Spoon)SpoonFactory.getInstance()).getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SpoonPluginInterface sp = SpoonPluginManager.this.loadPlugin((SpoonPluginInterface)PluginRegistry.getInstance().loadClass((PluginInterface)serviceObject));
                            if (sp == null) {
                                return;
                            }
                            sp.applyToContainer(category, container);
                        }
                        catch (KettlePluginException e) {
                            e.printStackTrace();
                        }
                        catch (XulException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }

            public void pluginRemoved(Object serviceObject) {
            }

            public void pluginChanged(Object serviceObject) {
            }
        });
    }

    public List<SpoonPluginInterface> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    public void notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent evt) {
        for (SpoonPluginInterface p : this.plugins) {
            SpoonLifecycleListener listener = p.getLifecycleListener();
            if (listener == null) continue;
            listener.onEvent(evt);
        }
    }
}

