/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.uisupport;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.uisupport.IRepositoryExplorerUISupport;
import org.pentaho.di.ui.repository.repositoryexplorer.uisupport.RepositoryExplorerDefaultXulOverlay;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.impl.XulEventHandler;

public abstract class AbstractRepositoryExplorerUISupport
implements IRepositoryExplorerUISupport {
    protected List<XulEventHandler> handlers = new ArrayList<XulEventHandler>();
    protected List<XulOverlay> overlays = new ArrayList<XulOverlay>();
    protected XulDomContainer container;
    protected List<String> controllerNames = new ArrayList<String>();

    public AbstractRepositoryExplorerUISupport() {
        this.setup();
    }

    @Override
    public void apply(XulDomContainer container) throws XulException {
        this.container = container;
        container.registerClassLoader((Object)this.getClass().getClassLoader());
        for (XulEventHandler handler : this.handlers) {
            container.addEventHandler(handler);
        }
        for (XulOverlay overlay : this.overlays) {
            if (overlay instanceof RepositoryExplorerDefaultXulOverlay) {
                container.loadOverlay(overlay.getOverlayUri(), (Object)new XulSpoonResourceBundle(((RepositoryExplorerDefaultXulOverlay)overlay).getPackageClass()));
                continue;
            }
            container.loadOverlay(overlay.getOverlayUri(), (Object)overlay.getResourceBundleUri());
        }
    }

    @Override
    public List<XulEventHandler> getEventHandlers() {
        return this.handlers;
    }

    @Override
    public List<XulOverlay> getOverlays() {
        return this.overlays;
    }

    @Override
    public void initControllers(Repository rep) throws ControllerInitializationException {
        for (String name : this.controllerNames) {
            try {
                IUISupportController controller = (IUISupportController)this.container.getEventHandler(name);
                controller.init(rep);
            }
            catch (XulException e) {
                throw new ControllerInitializationException(e);
            }
        }
    }

    protected abstract void setup();
}

