/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public abstract class LazilyInitializedController
extends AbstractXulEventHandler {
    private static Class<?> PKG = RepositoryExplorer.class;
    protected Repository repository;
    protected boolean initialized;

    public void init(Repository repository) throws ControllerInitializationException {
        this.repository = repository;
    }

    protected synchronized void lazyInit() {
        if (!this.initialized) {
            try {
                boolean succeeded = this.doLazyInit();
                if (succeeded) {
                    this.initialized = true;
                } else {
                    this.showErrorDialog(null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showErrorDialog(e);
            }
        }
    }

    private void showErrorDialog(Exception e) {
        XulMessageBox messageBox = null;
        try {
            messageBox = (XulMessageBox)this.document.createElement("messagebox");
        }
        catch (XulException xe) {
            throw new RuntimeException(xe);
        }
        messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
        messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
        if (e != null) {
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"LazilyInitializedController.Message.UnableToInitWithParam", (String[])new String[]{e.getLocalizedMessage()}));
        } else {
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"LazilyInitializedController.Message.UnableToInit", (String[])new String[0]));
        }
        messageBox.open();
    }

    protected abstract boolean doLazyInit();

    protected void doWithBusyIndicator(Runnable r) {
        BusyIndicator.showWhile((Display)(Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault()), (Runnable)r);
    }

    protected void doInEventThread(Runnable r) {
        if (Display.getCurrent() != null) {
            r.run();
        } else {
            Display.getDefault().syncExec(r);
        }
    }
}

