/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.repository.ILoginCallback;
import org.pentaho.di.ui.repository.controllers.RepositoriesController;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulRunner;

public class RepositoriesDialog {
    private static final Class<?> CLZ = RepositoriesDialog.class;
    private static Log log = LogFactory.getLog(RepositoriesDialog.class);
    private RepositoriesController repositoriesController = new RepositoriesController();
    private XulDomContainer container;
    private ILoginCallback callback;
    private ResourceBundle resourceBundle = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)CLZ, (String)key, (String[])new String[0]);
        }
    };

    public RepositoriesDialog(Shell shell, String preferredRepositoryName, ILoginCallback callback) {
        try {
            this.callback = callback;
            KettleXulLoader xulLoader = new KettleXulLoader();
            xulLoader.setOuterContext(shell);
            xulLoader.setSettingsManager(XulSpoonSettingsManager.getInstance());
            this.container = xulLoader.loadXul("org/pentaho/di/ui/repository/xul/repositories.xul", this.resourceBundle);
            SwtXulRunner runner = new SwtXulRunner();
            runner.addContainer(this.container);
            DefaultBindingFactory bf = new DefaultBindingFactory();
            bf.setDocument(this.container.getDocumentRoot());
            this.repositoriesController.setBindingFactory((BindingFactory)bf);
            this.repositoriesController.setPreferredRepositoryName(preferredRepositoryName);
            this.repositoriesController.setMessages(this.resourceBundle);
            this.repositoriesController.setCallback(callback);
            this.repositoriesController.setShell(this.getShell());
            this.container.addEventHandler((XulEventHandler)this.repositoriesController);
            try {
                runner.initialize();
            }
            catch (XulException e) {
                SpoonFactory.getInstance().messageBox(e.getLocalizedMessage(), "Service Initialization Failed", false, 2);
                log.error((Object)this.resourceBundle.getString("RepositoryLoginDialog.ErrorStartingXulApplication"), (Throwable)e);
            }
        }
        catch (XulException e) {
            log.error((Object)this.resourceBundle.getString("RepositoryLoginDialog.ErrorLoadingXulApplication"), (Throwable)e);
        }
    }

    public Composite getDialogArea() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("repository-login-dialog");
        return (Composite)dialog.getManagedObject();
    }

    public void show() {
        this.repositoriesController.show();
    }

    public ILoginCallback getCallback() {
        return this.callback;
    }

    public Shell getShell() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("repository-login-dialog");
        return (Shell)dialog.getRootObject();
    }
}

