/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ControlSpaceKeyAdapter;
import org.pentaho.di.ui.core.widget.GetCaretPositionInterface;
import org.pentaho.di.ui.core.widget.InsertTextInterface;

public class TextVar
extends Composite {
    private static Class<?> PKG = TextVar.class;
    private String toolTipText;
    private ControlDecoration controlDecoration;
    private GetCaretPositionInterface getCaretPositionInterface;
    private InsertTextInterface insertTextInterface;
    private ControlSpaceKeyAdapter controlSpaceKeyAdapter;
    private VariableSpace variables;
    private Text wText;
    private ModifyListener modifyListenerTooltipText;

    public TextVar(VariableSpace space, Composite composite, int flags) {
        this(space, composite, flags, null, null, null);
    }

    public TextVar(VariableSpace space, Composite composite, int flags, String toolTipText) {
        this(space, composite, flags, toolTipText, null, null);
    }

    public TextVar(VariableSpace space, Composite composite, int flags, GetCaretPositionInterface getCaretPositionInterface, InsertTextInterface insertTextInterface) {
        this(space, composite, flags, null, getCaretPositionInterface, insertTextInterface);
    }

    public TextVar(VariableSpace space, Composite composite, int flags, String toolTipText, GetCaretPositionInterface getCaretPositionInterface, InsertTextInterface insertTextInterface) {
        super(composite, 0);
        this.toolTipText = toolTipText;
        this.getCaretPositionInterface = getCaretPositionInterface;
        this.insertTextInterface = insertTextInterface;
        this.variables = space;
        PropsUI.getInstance().setLook((Control)this);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        formLayout.marginTop = 0;
        formLayout.marginBottom = 0;
        this.setLayout((Layout)formLayout);
        this.wText = new Text((Composite)this, flags);
        this.controlDecoration = new ControlDecoration((Control)this.wText, 131200, (Composite)this);
        Image image = GUIResource.getInstance().getImageVariable();
        this.controlDecoration.setImage(image);
        this.controlDecoration.setDescriptionText(BaseMessages.getString(PKG, (String)"TextVar.tooltip.InsertVariable", (String[])new String[0]));
        PropsUI.getInstance().setLook(this.controlDecoration.getControl());
        this.modifyListenerTooltipText = this.getModifyListenerTooltipText(this.wText);
        this.wText.addModifyListener(this.modifyListenerTooltipText);
        this.controlSpaceKeyAdapter = new ControlSpaceKeyAdapter(this.variables, (Control)this.wText, getCaretPositionInterface, insertTextInterface);
        this.wText.addKeyListener((KeyListener)this.controlSpaceKeyAdapter);
        FormData fdText = new FormData();
        fdText.top = new FormAttachment(0, 0);
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, -image.getBounds().width);
        this.wText.setLayoutData((Object)fdText);
    }

    public GetCaretPositionInterface getGetCaretPositionInterface() {
        return this.getCaretPositionInterface;
    }

    public void setGetCaretPositionInterface(GetCaretPositionInterface getCaretPositionInterface) {
        this.getCaretPositionInterface = getCaretPositionInterface;
    }

    public InsertTextInterface getInsertTextInterface() {
        return this.insertTextInterface;
    }

    public void setInsertTextInterface(InsertTextInterface insertTextInterface) {
        this.insertTextInterface = insertTextInterface;
    }

    private ModifyListener getModifyListenerTooltipText(final Text textField) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (textField.getEchoChar() == '\u0000') {
                    String tip = textField.getText();
                    if (!Const.isEmpty((String)tip) && !Const.isEmpty((String)TextVar.this.toolTipText)) {
                        tip = tip + Const.CR + Const.CR + TextVar.this.toolTipText;
                    }
                    if (Const.isEmpty((String)tip)) {
                        tip = TextVar.this.toolTipText;
                    }
                    textField.setToolTipText(TextVar.this.variables.environmentSubstitute(tip));
                }
            }
        };
    }

    public String getText() {
        return this.wText.getText();
    }

    public void setText(String text) {
        this.wText.setText(text);
        this.modifyListenerTooltipText.modifyText(null);
    }

    public Text getTextWidget() {
        return this.wText;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.wText.addModifyListener(modifyListener);
    }

    public void addSelectionListener(SelectionAdapter lsDef) {
        this.wText.addSelectionListener((SelectionListener)lsDef);
    }

    public void addKeyListener(KeyListener lsKey) {
        this.wText.addKeyListener(lsKey);
    }

    public void addFocusListener(FocusListener lsFocus) {
        this.wText.addFocusListener(lsFocus);
    }

    public void setEchoChar(char c) {
        this.wText.setEchoChar(c);
    }

    public void setEnabled(boolean flag) {
        this.wText.setEnabled(flag);
    }

    public boolean setFocus() {
        return this.wText.setFocus();
    }

    public void addTraverseListener(TraverseListener tl) {
        this.wText.addTraverseListener(tl);
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        this.wText.setToolTipText(toolTipText);
        this.modifyListenerTooltipText.modifyText(null);
    }

    public void setEditable(boolean editable) {
        this.wText.setEditable(editable);
    }

    public void setSelection(int i) {
        this.wText.setSelection(i);
    }

    public void selectAll() {
        this.wText.selectAll();
    }

    public void showSelection() {
        this.wText.showSelection();
    }

    public void setVariables(VariableSpace vars) {
        this.variables = vars;
        this.controlSpaceKeyAdapter.setVariables(this.variables);
        this.modifyListenerTooltipText.modifyText(null);
    }
}

