/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.clipboard;

import org.pentaho.di.core.clipboard.BITMAPINFOHEADER;

class ConversionUtil {
    private ConversionUtil() {
    }

    public static int bytesToInt(byte[] bytes, int start) {
        int a = 0xFF & bytes[start + 0];
        int b = 0xFF00 & bytes[start + 1] << 8;
        int c = 0xFF0000 & bytes[start + 2] << 16;
        int d = 0xFF000000 & bytes[start + 3] << 24;
        return a + b + c + d;
    }

    public static short bytesToShort(byte[] bytes, int start) {
        short a = (short)(0xFF & bytes[start + 0]);
        short b = (short)(0xFF00 & bytes[start + 1] << 8);
        return (short)(a + b);
    }

    public static void intToBytes(int val, byte[] bytes, int start) {
        bytes[start + 0] = (byte)val;
        bytes[start + 1] = (byte)(0xFF & val >> 8);
        bytes[start + 2] = (byte)(0xFF & val >> 16);
        bytes[start + 3] = (byte)(0xFF & val >> 24);
    }

    public static void shortToBytes(short val, byte[] bytes, int start) {
        bytes[start + 0] = (byte)val;
        bytes[start + 1] = (byte)(0xFF & val >> 8);
    }

    public static void fromBytes(BITMAPINFOHEADER dest, byte[] src, int start) {
        dest.biSize = ConversionUtil.bytesToInt(src, start + 0);
        dest.biWidth = ConversionUtil.bytesToInt(src, start + 4);
        dest.biHeight = ConversionUtil.bytesToInt(src, start + 8);
        dest.biPlanes = ConversionUtil.bytesToShort(src, start + 12);
        dest.biBitCount = ConversionUtil.bytesToShort(src, start + 14);
        dest.biCompression = ConversionUtil.bytesToInt(src, start + 16);
        dest.biSizeImage = ConversionUtil.bytesToInt(src, start + 20);
        dest.biXPelsPerMeter = ConversionUtil.bytesToInt(src, start + 24);
        dest.biYPelsPerMeter = ConversionUtil.bytesToInt(src, start + 28);
        dest.biClrUsed = ConversionUtil.bytesToInt(src, start + 32);
        dest.biClrImportant = ConversionUtil.bytesToInt(src, start + 36);
        if (dest.biPlanes != 1) {
            throw new IllegalArgumentException("incorrect bitmap info format.");
        }
        if (dest.biSize != 40) {
            throw new IllegalArgumentException("incorrect size. cannot do v4 or v5 bitmaps yet");
        }
    }

    public static void toBytes(BITMAPINFOHEADER src, byte[] dest, int start) {
        ConversionUtil.intToBytes(src.biSize, dest, start);
        ConversionUtil.intToBytes(src.biWidth, dest, start + 4);
        ConversionUtil.intToBytes(src.biHeight, dest, start + 8);
        ConversionUtil.shortToBytes(src.biPlanes, dest, start + 12);
        ConversionUtil.shortToBytes(src.biBitCount, dest, start + 14);
        ConversionUtil.intToBytes(src.biCompression, dest, start + 16);
        ConversionUtil.intToBytes(src.biSizeImage, dest, start + 20);
        ConversionUtil.intToBytes(src.biXPelsPerMeter, dest, start + 24);
        ConversionUtil.intToBytes(src.biYPelsPerMeter, dest, start + 28);
        ConversionUtil.intToBytes(src.biClrUsed, dest, start + 32);
        ConversionUtil.intToBytes(src.biClrImportant, dest, start + 36);
    }
}

