/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.util.AbstractList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeList<T>
extends AbstractList<T> {
    private final List<T>[] lists;

    public CompositeList(List<T> ... lists) {
        this.lists = lists;
    }

    public static <T> CompositeList<T> of(List<T> ... lists) {
        return new CompositeList<T>(lists);
    }

    @Override
    public T get(int index) {
        for (List<T> list : this.lists) {
            int nextIndex = index - list.size();
            if (nextIndex < 0) {
                return list.get(index);
            }
            index = nextIndex;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        int n = 0;
        for (List<T> list : this.lists) {
            n += list.size();
        }
        return n;
    }
}

