/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.parser;

import java.io.StringReader;
import java.util.Arrays;
import net.hydromatic.avatica.Casing;
import net.hydromatic.avatica.Quoting;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.impl.SqlParserImpl;
import org.eigenbase.sql.parser.impl.SqlParserImplTokenManager;
import org.eigenbase.util.EigenbaseContextException;

public class SqlParser {
    private final SqlParserImpl parser;
    private String originalInput;

    public SqlParser(String s) {
        this(s, Quoting.DOUBLE_QUOTE, Casing.TO_UPPER, Casing.UNCHANGED);
    }

    public SqlParser(String s, Quoting quoting, Casing unquotedCasing, Casing quotedCasing) {
        this.parser = new SqlParserImpl(new StringReader(s));
        this.parser.setTabSize(1);
        this.parser.quotedCasing = quotedCasing;
        this.parser.unquotedCasing = unquotedCasing;
        this.originalInput = s;
        switch (quoting) {
            case DOUBLE_QUOTE: {
                this.switchTo("DQID");
                break;
            }
            case BACK_TICK: {
                this.switchTo("BTID");
                break;
            }
            case BRACKET: {
                this.switchTo("DEFAULT");
            }
        }
    }

    public void switchTo(String stateName) {
        int state = Arrays.asList(SqlParserImplTokenManager.lexStateNames).indexOf(stateName);
        this.parser.token_source.SwitchTo(state);
    }

    public SqlNode parseExpression() throws SqlParseException {
        try {
            return this.parser.SqlExpressionEof();
        }
        catch (Throwable ex) {
            if (ex instanceof EigenbaseContextException && this.originalInput != null) {
                ((EigenbaseContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlNode parseQuery() throws SqlParseException {
        try {
            return this.parser.SqlStmtEof();
        }
        catch (Throwable ex) {
            if (ex instanceof EigenbaseContextException && this.originalInput != null) {
                ((EigenbaseContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlNode parseStmt() throws SqlParseException {
        try {
            return this.parser.SqlStmtEof();
        }
        catch (Throwable ex) {
            if (ex instanceof EigenbaseContextException && this.originalInput != null) {
                ((EigenbaseContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlParserImpl getParserImpl() {
        return this.parser;
    }
}

