/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.resource.EigenbaseResource;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlRankFunction
extends SqlAggFunction {
    private final RelDataType type = null;

    public SqlRankFunction(String name) {
        super(name, SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER, null, OperandTypes.NILADIC, SqlFunctionCategory.NUMERIC);
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return this.type;
    }

    @Override
    public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
        return ImmutableList.of((Object)this.type);
    }

    @Override
    public boolean isAggregator() {
        return true;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        SqlParserPos pos = call.getParserPosition();
        throw SqlUtil.newContextException(pos, EigenbaseResource.instance().FunctionUndefined.ex(call.toString()));
    }
}

