/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.metadata;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.UnionRelBase;
import org.eigenbase.rel.ValuesRelBase;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMdUtil;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util14.NumberUtil;

public class RelMdDistinctRowCount {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltinMethod.DISTINCT_ROW_COUNT.method, new RelMdDistinctRowCount());

    protected RelMdDistinctRowCount() {
    }

    public Double getDistinctRowCount(UnionRelBase rel, BitSet groupKey, RexNode predicate) {
        Double rowCount = 0.0;
        int[] adjustments = new int[rel.getRowType().getFieldCount()];
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        for (RelNode input : rel.getInputs()) {
            RexNode modifiedPred;
            Double partialRowCount = RelMetadataQuery.getDistinctRowCount(input, groupKey, modifiedPred = predicate == null ? null : predicate.accept(new RelOptUtil.RexInputConverter(rexBuilder, null, input.getRowType().getFieldList(), adjustments)));
            if (partialRowCount == null) {
                return null;
            }
            rowCount = rowCount + partialRowCount;
        }
        return rowCount;
    }

    public Double getDistinctRowCount(SortRel rel, BitSet groupKey, RexNode predicate) {
        return RelMetadataQuery.getDistinctRowCount(rel.getChild(), groupKey, predicate);
    }

    public Double getDistinctRowCount(FilterRelBase rel, BitSet groupKey, RexNode predicate) {
        RexNode unionPreds = RelMdUtil.unionPreds(rel.getCluster().getRexBuilder(), predicate, rel.getCondition());
        return RelMetadataQuery.getDistinctRowCount(rel.getChild(), groupKey, unionPreds);
    }

    public Double getDistinctRowCount(JoinRelBase rel, BitSet groupKey, RexNode predicate) {
        return RelMdUtil.getJoinDistinctRowCount(rel, rel.getJoinType(), groupKey, predicate, false);
    }

    public Double getDistinctRowCount(SemiJoinRel rel, BitSet groupKey, RexNode predicate) {
        RexNode newPred = RelMdUtil.makeSemiJoinSelectivityRexNode(rel);
        if (predicate != null) {
            RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
            newPred = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newPred, predicate);
        }
        return RelMetadataQuery.getDistinctRowCount(rel.getLeft(), groupKey, newPred);
    }

    public Double getDistinctRowCount(AggregateRelBase rel, BitSet groupKey, RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(rel.getGroupSet(), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPreds = RexUtil.composeConjunction(rexBuilder, pushable, true);
        BitSet childKey = new BitSet();
        RelMdUtil.setAggChildKeys(groupKey, rel, childKey);
        Double distinctRowCount = RelMetadataQuery.getDistinctRowCount(rel.getChild(), childKey, childPreds);
        if (distinctRowCount == null) {
            return null;
        }
        if (notPushable.isEmpty()) {
            return distinctRowCount;
        }
        RexNode preds = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return distinctRowCount * RelMdUtil.guessSelectivity(preds);
    }

    public Double getDistinctRowCount(ValuesRelBase rel, BitSet groupKey, RexNode predicate) {
        Double selectivity = RelMdUtil.guessSelectivity(predicate);
        Double nRows = rel.getRows() / 2.0;
        return RelMdUtil.numDistinctVals(nRows, nRows * selectivity);
    }

    public Double getDistinctRowCount(ProjectRelBase rel, BitSet groupKey, RexNode predicate) {
        BitSet baseCols = new BitSet();
        BitSet projCols = new BitSet();
        List<RexNode> projExprs = rel.getProjects();
        RelMdUtil.splitCols(projExprs, groupKey, baseCols, projCols);
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(BitSets.range(rel.getRowType().getFieldCount()), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        RexNode modifiedPred = childPred == null ? null : RelOptUtil.pushFilterPastProject(childPred, rel);
        Double distinctRowCount = RelMetadataQuery.getDistinctRowCount(rel.getChild(), baseCols, modifiedPred);
        if (distinctRowCount == null) {
            return null;
        }
        if (!notPushable.isEmpty()) {
            RexNode preds = RexUtil.composeConjunction(rexBuilder, notPushable, true);
            distinctRowCount = distinctRowCount * RelMdUtil.guessSelectivity(preds);
        }
        if (projCols.cardinality() == 0) {
            return distinctRowCount;
        }
        for (int bit : BitSets.toIter(projCols)) {
            Double subRowCount = RelMdUtil.cardOfProjExpr(rel, projExprs.get(bit));
            if (subRowCount == null) {
                return null;
            }
            distinctRowCount = distinctRowCount * subRowCount;
        }
        return RelMdUtil.numDistinctVals(distinctRowCount, RelMetadataQuery.getRowCount(rel));
    }

    public Double getDistinctRowCount(RelNode rel, BitSet groupKey, RexNode predicate) {
        boolean uniq = RelMdUtil.areColumnsDefinitelyUnique(rel, groupKey);
        if (uniq) {
            return NumberUtil.multiply(RelMetadataQuery.getRowCount(rel), RelMetadataQuery.getSelectivity(rel, predicate));
        }
        return null;
    }
}

