/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexChecker;
import org.eigenbase.rex.RexFieldCollation;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexSlot;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WindowRelBase
extends SingleRel {
    public final ImmutableList<Window> windows;

    public WindowRelBase(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelDataType rowType, List<Window> windows) {
        super(cluster, traits, child);
        assert (rowType != null);
        this.rowType = rowType;
        this.windows = ImmutableList.copyOf(windows);
    }

    @Override
    public boolean isValid(boolean fail) {
        RexChecker checker = new RexChecker(this.getChild().getRowType(), fail);
        int count = 0;
        for (Window window : this.windows) {
            for (RexWinAggCall over : window.aggCalls) {
                ++count;
                if (checker.isValid(over)) continue;
                return false;
            }
        }
        if (count == 0) {
            assert (!fail) : "empty";
            return false;
        }
        return true;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord window : Ord.zip(this.windows)) {
            pw.item("window#" + window.i, ((Window)window.e).toString());
        }
        return pw;
    }

    static ImmutableIntList getProjectOrdinals(final List<RexNode> exprs) {
        return ImmutableIntList.copyOf((Collection<? extends Number>)new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return ((RexSlot)exprs.get(index)).getIndex();
            }

            @Override
            public int size() {
                return exprs.size();
            }
        });
    }

    static RelCollation getCollation(final List<RexFieldCollation> collations) {
        return RelCollationImpl.of((List<RelFieldCollation>)new AbstractList<RelFieldCollation>(){

            @Override
            public RelFieldCollation get(int index) {
                RexFieldCollation collation = (RexFieldCollation)collations.get(index);
                return new RelFieldCollation(((RexLocalRef)collation.left).getIndex(), collation.getDirection(), collation.getNullDirection());
            }

            @Override
            public int size() {
                return collations.size();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RexWinAggCall
    extends RexCall {
        public final int ordinal;

        public RexWinAggCall(SqlAggFunction aggFun, RelDataType type, List<RexNode> operands, int ordinal) {
            super(type, aggFun, operands);
            this.ordinal = ordinal;
        }

        @Override
        public RexCall clone(RelDataType type, List<RexNode> operands) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Window {
        public final BitSet groupSet;
        public final boolean isRows;
        public final SqlNode lowerBound;
        public final SqlNode upperBound;
        public final RelCollation orderKeys;
        private final String digest;
        public final ImmutableList<RexWinAggCall> aggCalls;

        public Window(BitSet groupSet, boolean isRows, SqlNode lowerBound, SqlNode upperBound, RelCollation orderKeys, List<RexWinAggCall> aggCalls) {
            assert (orderKeys != null) : "precondition: ordinals != null";
            assert (groupSet != null);
            this.groupSet = groupSet;
            this.isRows = isRows;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.orderKeys = orderKeys;
            this.aggCalls = ImmutableList.copyOf(aggCalls);
            this.digest = this.computeString();
        }

        public String toString() {
            return this.digest;
        }

        private String computeString() {
            StringBuilder buf = new StringBuilder();
            buf.append("window(partition ");
            buf.append(this.groupSet);
            buf.append(" order by ");
            buf.append(this.orderKeys);
            buf.append(this.isRows ? " rows " : " range ");
            if (this.lowerBound != null) {
                if (this.upperBound != null) {
                    buf.append("between ");
                    buf.append(this.lowerBound);
                    buf.append(" and ");
                    buf.append(this.upperBound);
                } else {
                    buf.append(this.lowerBound);
                }
            } else if (this.upperBound != null) {
                buf.append(this.upperBound);
            }
            buf.append(" aggs ");
            buf.append(this.aggCalls);
            buf.append(")");
            return buf.toString();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Window && this.digest.equals(((Window)obj).digest);
        }

        public int hashCode() {
            return this.digest.hashCode();
        }

        public RelCollation collation() {
            return this.orderKeys;
        }

        public List<AggregateCall> getAggregateCalls(WindowRelBase windowRel) {
            final List<String> fieldNames = Util.skip(windowRel.getRowType().getFieldNames(), windowRel.getChild().getRowType().getFieldCount());
            return new AbstractList<AggregateCall>(){

                @Override
                public int size() {
                    return Window.this.aggCalls.size();
                }

                @Override
                public AggregateCall get(int index) {
                    RexWinAggCall aggCall = (RexWinAggCall)Window.this.aggCalls.get(index);
                    return new AggregateCall((Aggregation)((Object)aggCall.getOperator()), false, WindowRelBase.getProjectOrdinals(aggCall.getOperands()), aggCall.getType(), (String)fieldNames.get(aggCall.ordinal));
                }
            };
        }
    }
}

