/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableFunction;
import net.hydromatic.optiq.impl.MaterializedViewTable;
import net.hydromatic.optiq.jdbc.OptiqRootSchema;
import net.hydromatic.optiq.util.Compatible;
import net.hydromatic.optiq.util.CompositeMap;
import org.eigenbase.util.Util;

public class OptiqSchema {
    private final OptiqSchema parent;
    public final Schema schema;
    public final Map<String, TableEntry> tableMap = new HashMap<String, TableEntry>();
    public final Map<String, TableEntry> tableMapInsensitive = new TreeMap<String, TableEntry>(String.CASE_INSENSITIVE_ORDER);
    private final Multimap<String, TableFunctionEntry> tableFunctionMap = LinkedListMultimap.create();
    private final Map<String, TableFunctionEntry> nullaryTableFunctionMapInsensitive = new TreeMap<String, TableFunctionEntry>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, OptiqSchema> subSchemaMap = new HashMap<String, OptiqSchema>();
    private final Map<String, OptiqSchema> subSchemaMapInsensitive = new TreeMap<String, OptiqSchema>(String.CASE_INSENSITIVE_ORDER);
    public final Map<String, Table> compositeTableMap;
    public final Multimap<String, TableFunction> compositeTableFunctionMap;
    public final Map<String, OptiqSchema> compositeSubSchemaMap;

    public OptiqSchema(OptiqSchema parent, final Schema schema) {
        this.parent = parent;
        this.schema = schema;
        assert (parent == null == this instanceof OptiqRootSchema);
        this.compositeTableMap = CompositeMap.of(Maps.transformValues(this.tableMap, (Function)new Function<TableEntry, Table>(){

            public Table apply(TableEntry input) {
                return input.getTable();
            }
        }), Maps.transformValues((Map)Multimaps.filterEntries(this.tableFunctionMap, (Predicate)new Predicate<Map.Entry<String, TableFunctionEntry>>(){

            public boolean apply(Map.Entry<String, TableFunctionEntry> input) {
                return input.getValue().getTableFunction().getParameters().isEmpty();
            }
        }).asMap(), (Function)new Function<Collection<TableFunctionEntry>, Table>(){

            public Table apply(Collection<TableFunctionEntry> input) {
                TableFunctionEntry entry = input.iterator().next();
                return entry.getTableFunction().apply((List<Object>)ImmutableList.of());
            }
        }), Compatible.INSTANCE.asMap(schema.getTableNames(), new Function<String, Table>(){

            public Table apply(String input) {
                return schema.getTable(input);
            }
        }));
        this.compositeTableFunctionMap = Multimaps.transformValues(this.tableFunctionMap, (Function)new Function<TableFunctionEntry, TableFunction>(){

            public TableFunction apply(TableFunctionEntry input) {
                return input.getTableFunction();
            }
        });
        this.compositeSubSchemaMap = CompositeMap.of(this.subSchemaMap, Compatible.INSTANCE.asMap(schema.getSubSchemaNames(), new Function<String, OptiqSchema>(){

            public OptiqSchema apply(String input) {
                return OptiqSchema.this.addSchema(schema.getSubSchema(input));
            }
        }));
    }

    public TableEntry add(String tableName, Table table) {
        TableEntryImpl entry = new TableEntryImpl(this, tableName, table);
        this.tableMap.put(tableName, entry);
        this.tableMapInsensitive.put(tableName, entry);
        return entry;
    }

    private TableFunctionEntry add(String name, TableFunction tableFunction) {
        TableFunctionEntryImpl entry = new TableFunctionEntryImpl(this, name, tableFunction);
        this.tableFunctionMap.put((Object)name, (Object)entry);
        if (tableFunction.getParameters().isEmpty()) {
            this.nullaryTableFunctionMapInsensitive.put(name, entry);
        }
        return entry;
    }

    public OptiqRootSchema root() {
        OptiqSchema schema = this;
        while (schema.parent != null) {
            schema = schema.parent;
        }
        return (OptiqRootSchema)schema;
    }

    public final OptiqSchema getSubSchema(String schemaName, boolean caseSensitive) {
        return (caseSensitive ? this.subSchemaMap : this.subSchemaMapInsensitive).get(schemaName);
    }

    public OptiqSchema addSchema(Schema schema) {
        OptiqSchema optiqSchema = new OptiqSchema(this, schema);
        this.subSchemaMap.put(schema.getName(), optiqSchema);
        this.subSchemaMapInsensitive.put(schema.getName(), optiqSchema);
        return optiqSchema;
    }

    public final Table getTable(String tableName, boolean caseSensitive) {
        if (caseSensitive) {
            return this.compositeTableMap.get(tableName);
        }
        TableEntry tableEntry = this.tableMapInsensitive.get(tableName);
        if (tableEntry != null) {
            return tableEntry.getTable();
        }
        TableFunctionEntry entry = this.nullaryTableFunctionMapInsensitive.get(tableName);
        if (entry != null) {
            return entry.getTableFunction().apply((List<Object>)ImmutableList.of());
        }
        for (String name : this.schema.getTableNames()) {
            if (!name.equalsIgnoreCase(tableName)) continue;
            return this.schema.getTable(name);
        }
        return null;
    }

    public String getName() {
        return this.schema.getName();
    }

    public void addTableFunction(TableFunctionEntry tableFunctionEntry) {
        throw Util.needToImplement(tableFunctionEntry);
    }

    public SchemaPlus plus() {
        return new SchemaPlusImpl();
    }

    public static OptiqSchema from(SchemaPlus plus) {
        return ((SchemaPlusImpl)plus).optiqSchema();
    }

    public static class TableFunctionEntryImpl
    extends TableFunctionEntry {
        private final TableFunction tableFunction;

        public TableFunctionEntryImpl(OptiqSchema schema, String name, TableFunction tableFunction) {
            super(schema, name);
            this.tableFunction = tableFunction;
        }

        public TableFunction getTableFunction() {
            return this.tableFunction;
        }

        public boolean isMaterialization() {
            return this.tableFunction instanceof MaterializedViewTable.MaterializedViewTableFunction;
        }
    }

    public static class TableEntryImpl
    extends TableEntry {
        private final Table table;

        public TableEntryImpl(OptiqSchema schema, String name, Table table) {
            super(schema, name);
            assert (table != null);
            this.table = table;
        }

        public Table getTable() {
            return this.table;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SchemaPlusImpl
    implements SchemaPlus {
        private SchemaPlusImpl() {
        }

        public OptiqSchema optiqSchema() {
            return OptiqSchema.this;
        }

        @Override
        public SchemaPlus getParentSchema() {
            return OptiqSchema.this.parent == null ? null : OptiqSchema.this.parent.plus();
        }

        @Override
        public String getName() {
            return OptiqSchema.this.getName();
        }

        @Override
        public boolean isMutable() {
            return OptiqSchema.this.schema.isMutable();
        }

        @Override
        public Expression getExpression() {
            return OptiqSchema.this.schema.getExpression();
        }

        @Override
        public Table getTable(String name) {
            return OptiqSchema.this.compositeTableMap.get(name);
        }

        @Override
        public Set<String> getTableNames() {
            return OptiqSchema.this.compositeTableMap.keySet();
        }

        @Override
        public Collection<TableFunction> getTableFunctions(String name) {
            return OptiqSchema.this.compositeTableFunctionMap.get((Object)name);
        }

        @Override
        public Set<String> getTableFunctionNames() {
            return OptiqSchema.this.compositeTableFunctionMap.keySet();
        }

        @Override
        public SchemaPlus getSubSchema(String name) {
            OptiqSchema subSchema = OptiqSchema.this.getSubSchema(name, true);
            return subSchema == null ? null : subSchema.plus();
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return OptiqSchema.this.subSchemaMap.keySet();
        }

        @Override
        public SchemaPlus add(Schema schema) {
            OptiqSchema optiqSchema = OptiqSchema.this.addSchema(schema);
            return optiqSchema.plus();
        }

        @Override
        public SchemaPlus addRecursive(Schema schema) {
            return schema.getParentSchema().add(schema);
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this)) {
                return clazz.cast(this);
            }
            if (clazz.isInstance(OptiqSchema.this)) {
                return clazz.cast(OptiqSchema.this);
            }
            if (clazz.isInstance(OptiqSchema.this.schema)) {
                return clazz.cast(OptiqSchema.this.schema);
            }
            throw new ClassCastException("not a " + clazz);
        }

        @Override
        public void add(String name, Table table) {
            OptiqSchema.this.add(name, table);
        }

        @Override
        public void add(String name, TableFunction tableFunction) {
            OptiqSchema.this.add(name, tableFunction);
        }
    }

    public static abstract class TableFunctionEntry
    extends Entry {
        public TableFunctionEntry(OptiqSchema schema, String name) {
            super(schema, name);
        }

        public abstract TableFunction getTableFunction();

        public abstract boolean isMaterialization();
    }

    public static abstract class TableEntry
    extends Entry {
        public TableEntry(OptiqSchema schema, String name) {
            super(schema, name);
        }

        public abstract Table getTable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Entry {
        public final OptiqSchema schema;
        public final String name;

        public Entry(OptiqSchema schema, String name) {
            Linq4j.requireNonNull((Object)schema);
            Linq4j.requireNonNull((Object)name);
            this.schema = schema;
            this.name = name;
        }

        public final List<String> path() {
            return Schemas.path(this.schema.schema, this.name);
        }
    }
}

