/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.jdbc;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaFactory;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableFunction;
import net.hydromatic.optiq.impl.jdbc.JdbcConvention;
import net.hydromatic.optiq.impl.jdbc.JdbcTable;
import net.hydromatic.optiq.impl.jdbc.JdbcUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeImpl;
import org.eigenbase.reltype.RelProtoDataType;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.type.SqlTypeFactoryImpl;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcSchema
implements Schema {
    private final SchemaPlus parentSchema;
    private final String name;
    final DataSource dataSource;
    final String catalog;
    final String schema;
    public final SqlDialect dialect;
    final JdbcConvention convention;
    private Supplier<Map<String, JdbcTable>> tableMapSupplier = Suppliers.memoize((Supplier)new Supplier<Map<String, JdbcTable>>(){

        public Map<String, JdbcTable> get() {
            return JdbcSchema.this.computeTables();
        }
    });

    public JdbcSchema(SchemaPlus parentSchema, String name, DataSource dataSource, SqlDialect dialect, String catalog, String schema) {
        this.parentSchema = parentSchema;
        this.name = name;
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.catalog = catalog;
        this.schema = schema;
        this.convention = JdbcConvention.of(this, name);
        assert (dialect != null);
        assert (dataSource != null);
    }

    public static JdbcSchema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        DataSource dataSource;
        try {
            String dataSourceName = (String)operand.get("dataSource");
            if (dataSourceName != null) {
                Class<?> clazz = Class.forName(dataSourceName);
                dataSource = (DataSource)clazz.newInstance();
            } else {
                String jdbcUrl = (String)operand.get("jdbcUrl");
                String jdbcDriver = (String)operand.get("jdbcDriver");
                String jdbcUser = (String)operand.get("jdbcUser");
                String jdbcPassword = (String)operand.get("jdbcPassword");
                dataSource = JdbcSchema.dataSource(jdbcUrl, jdbcDriver, jdbcUser, jdbcPassword);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading dataSource", e);
        }
        String jdbcCatalog = (String)operand.get("jdbcCatalog");
        String jdbcSchema = (String)operand.get("jdbcSchema");
        SqlDialect dialect = JdbcSchema.createDialect(dataSource);
        return new JdbcSchema(parentSchema, name, dataSource, dialect, jdbcCatalog, jdbcSchema);
    }

    public static SqlDialect createDialect(DataSource dataSource) {
        return JdbcUtils.DialectPool.INSTANCE.get(dataSource);
    }

    public static DataSource dataSource(String url, String driverClassName, String username, String password) {
        if (url.startsWith("jdbc:hsqldb:")) {
            System.setProperty("hsqldb.reconfig_logging", "false");
        }
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        dataSource.setDriverClassName(driverClassName);
        return dataSource;
    }

    @Override
    public SchemaPlus getParentSchema() {
        return this.parentSchema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Expression getExpression() {
        return Schemas.subSchemaExpression(this.parentSchema, this.name, JdbcSchema.class);
    }

    protected Multimap<String, TableFunction> getTableFunctions() {
        return ImmutableMultimap.of();
    }

    @Override
    public final Collection<TableFunction> getTableFunctions(String name) {
        return this.getTableFunctions().get((Object)name);
    }

    @Override
    public final Set<String> getTableFunctionNames() {
        return this.getTableFunctions().keySet();
    }

    private ImmutableMap<String, JdbcTable> computeTables() {
        ImmutableMap immutableMap;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            resultSet = metaData.getTables(this.catalog, this.schema, null, null);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            while (resultSet.next()) {
                String tableName = resultSet.getString(3);
                String catalogName = resultSet.getString(1);
                String schemaName = resultSet.getString(2);
                String tableTypeName = resultSet.getString(4);
                String tableTypeName2 = tableTypeName.toUpperCase().replace(' ', '_');
                Schema.TableType tableType = Util.enumVal(Schema.TableType.class, tableTypeName2);
                JdbcTable table = new JdbcTable(this, catalogName, schemaName, tableName, tableType);
                builder.put((Object)tableName, (Object)table);
            }
            immutableMap = builder.build();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("Exception while reading tables", e);
            }
            catch (Throwable throwable) {
                JdbcSchema.close(connection, null, resultSet);
                throw throwable;
            }
        }
        JdbcSchema.close(connection, null, resultSet);
        return immutableMap;
    }

    @Override
    public Table getTable(String name) {
        return (Table)((Map)this.tableMapSupplier.get()).get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelProtoDataType getRelDataType(String catalogName, String schemaName, String tableName) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            RelProtoDataType relProtoDataType = this.getRelDataType(metaData, catalogName, schemaName, tableName);
            return relProtoDataType;
        }
        finally {
            JdbcSchema.close(connection, null, null);
        }
    }

    RelProtoDataType getRelDataType(DatabaseMetaData metaData, String catalogName, String schemaName, String tableName) throws SQLException {
        ResultSet resultSet = metaData.getColumns(catalogName, schemaName, tableName, null);
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl();
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        while (resultSet.next()) {
            String columnName = resultSet.getString(4);
            int dataType = resultSet.getInt(5);
            String typeString = resultSet.getString(6);
            int size = resultSet.getInt(7);
            int scale = resultSet.getInt(9);
            RelDataType sqlType = this.sqlType(typeFactory, dataType, size, scale, typeString);
            boolean nullable = resultSet.getBoolean(11);
            fieldInfo.add(columnName, sqlType).nullable(nullable);
        }
        resultSet.close();
        return RelDataTypeImpl.proto(fieldInfo.build());
    }

    private RelDataType sqlType(RelDataTypeFactory typeFactory, int dataType, int precision, int scale, String typeString) {
        SqlTypeName sqlTypeName = SqlTypeName.getNameForJdbcType(dataType);
        switch (sqlTypeName) {
            case ARRAY: {
                RelDataType component = null;
                if (typeString != null && typeString.endsWith(" ARRAY")) {
                    String remaining = typeString.substring(0, typeString.length() - " ARRAY".length());
                    component = this.parseTypeString(typeFactory, remaining);
                }
                if (component == null) {
                    component = typeFactory.createSqlType(SqlTypeName.ANY);
                }
                return typeFactory.createArrayType(component, -1L);
            }
        }
        if (precision >= 0 && scale >= 0 && sqlTypeName.allowsPrecScale(true, true)) {
            return typeFactory.createSqlType(sqlTypeName, precision, scale);
        }
        if (precision >= 0 && sqlTypeName.allowsPrecNoScale()) {
            return typeFactory.createSqlType(sqlTypeName, precision);
        }
        assert (sqlTypeName.allowsNoPrecNoScale());
        return typeFactory.createSqlType(sqlTypeName);
    }

    private RelDataType parseTypeString(RelDataTypeFactory typeFactory, String typeString) {
        int close;
        int precision = -1;
        int scale = -1;
        int open = typeString.indexOf("(");
        if (open >= 0 && (close = typeString.indexOf(")", open)) >= 0) {
            String rest = typeString.substring(open + 1, close);
            typeString = typeString.substring(0, open);
            int comma = rest.indexOf(",");
            if (comma >= 0) {
                precision = Integer.parseInt(rest.substring(0, comma));
                scale = Integer.parseInt(rest.substring(comma));
            } else {
                precision = Integer.parseInt(rest);
            }
        }
        try {
            SqlTypeName typeName = SqlTypeName.valueOf(typeString);
            return typeName.allowsPrecScale(true, true) ? typeFactory.createSqlType(typeName, precision, scale) : (typeName.allowsPrecScale(true, false) ? typeFactory.createSqlType(typeName, precision) : typeFactory.createSqlType(typeName));
        }
        catch (IllegalArgumentException e) {
            return typeFactory.createSqlType(SqlTypeName.ANY);
        }
    }

    @Override
    public Set<String> getTableNames() {
        return ((Map)this.tableMapSupplier.get()).keySet();
    }

    @Override
    public Schema getSubSchema(String name) {
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return ImmutableSet.of();
    }

    private static void close(Connection connection, Statement statement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements SchemaFactory {
        @Override
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            return JdbcSchema.create(parentSchema, name, operand);
        }
    }
}

