/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.clone;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Statistic;
import net.hydromatic.optiq.Statistics;
import net.hydromatic.optiq.impl.AbstractTableQueryable;
import net.hydromatic.optiq.impl.clone.ColumnLoader;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelProtoDataType;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayTable
extends AbstractQueryableTable {
    private final RelProtoDataType protoRowType;
    private final Supplier<Content> supplier;

    public ArrayTable(Type elementType, RelProtoDataType protoRowType, Supplier<Content> supplier) {
        super(elementType);
        this.protoRowType = protoRowType;
        this.supplier = supplier;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public Statistic getStatistic() {
        ArrayList<BitSet> keys = new ArrayList<BitSet>();
        Content content = (Content)this.supplier.get();
        for (Ord ord : Ord.zip((List)content.columns)) {
            if (((Column)ord.e).cardinality != content.size) continue;
            keys.add(BitSets.of(ord.i));
        }
        return Statistics.of(content.size, keys);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, this, tableName){

            public Enumerator<T> enumerator() {
                final Content content = (Content)ArrayTable.this.supplier.get();
                return new Enumerator(){
                    final int rowCount;
                    final int columnCount;
                    int i;
                    {
                        this.rowCount = content.size;
                        this.columnCount = content.columns.size();
                        this.i = -1;
                    }

                    public Object[] current() {
                        Object[] objects = new Object[this.columnCount];
                        for (int j = 0; j < objects.length; ++j) {
                            Column pair = (Column)content.columns.get(j);
                            objects[j] = pair.representation.getObject(pair.dataSet, this.i);
                        }
                        return objects;
                    }

                    public boolean moveNext() {
                        return ++this.i < this.rowCount;
                    }

                    public void reset() {
                        this.i = -1;
                    }

                    public void close() {
                    }
                };
            }
        };
    }

    private static <E> List<E> permuteList(final List<E> list, final int[] sources) {
        if (sources == null) {
            return list;
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return list.get(sources[index]);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Content {
        private final List<Column> columns;
        private final int size;
        private final int sortField;

        public Content(List<? extends Column> columns, int size, int sortField) {
            this.columns = ImmutableList.copyOf(columns);
            this.size = size;
            this.sortField = sortField;
        }
    }

    public static class BitSlicedPrimitiveArray
    implements Representation {
        final int ordinal;
        final int bitCount;
        final Primitive primitive;
        final boolean signed;

        BitSlicedPrimitiveArray(int ordinal, int bitCount, Primitive primitive, boolean signed) {
            assert (bitCount > 0);
            this.ordinal = ordinal;
            this.bitCount = bitCount;
            this.primitive = primitive;
            this.signed = signed;
        }

        public String toString() {
            return "BitSlicedPrimitiveArray(ordinal=" + this.ordinal + ", bitCount=" + this.bitCount + ", primitive=" + this.primitive + ", signed=" + this.signed + ")";
        }

        public RepresentationType getType() {
            return RepresentationType.BIT_SLICED_PRIMITIVE_ARRAY;
        }

        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            int chunksPerWord = 64 / this.bitCount;
            List valueList = ArrayTable.permuteList(valueSet.values, sources);
            int valueCount = valueList.size();
            int wordCount = (valueCount + (chunksPerWord - 1)) / chunksPerWord;
            int remainingChunkCount = valueCount % chunksPerWord;
            long[] longs = new long[wordCount];
            int n = valueCount / chunksPerWord;
            int k = 0;
            if (valueCount > 0 && valueList.get(0) instanceof Boolean) {
                int j;
                long v;
                List booleans = valueList;
                for (int i = 0; i < n; ++i) {
                    v = 0L;
                    for (j = 0; j < chunksPerWord; ++j) {
                        v |= (Boolean)booleans.get(k++) != false ? (long)(1 << this.bitCount * j) : 0L;
                    }
                    longs[i] = v;
                }
                if (remainingChunkCount > 0) {
                    v = 0L;
                    for (j = 0; j < remainingChunkCount; ++j) {
                        v |= (Boolean)booleans.get(k++) != false ? (long)(1 << this.bitCount * j) : 0L;
                    }
                    longs[i] = v;
                }
            } else {
                int j;
                long v;
                List numbers = valueList;
                for (int i = 0; i < n; ++i) {
                    v = 0L;
                    for (j = 0; j < chunksPerWord; ++j) {
                        v |= ((Number)numbers.get(k++)).longValue() << this.bitCount * j;
                    }
                    longs[i] = v;
                }
                if (remainingChunkCount > 0) {
                    v = 0L;
                    for (j = 0; j < remainingChunkCount; ++j) {
                        v |= ((Number)numbers.get(k++)).longValue() << this.bitCount * j;
                    }
                    longs[i] = v;
                }
            }
            return longs;
        }

        public Object permute(Object dataSet, int[] sources) {
            long[] longs0 = (long[])dataSet;
            int n = sources.length;
            long[] longs = new long[longs0.length];
            for (int i = 0; i < n; ++i) {
                BitSlicedPrimitiveArray.orLong(this.bitCount, longs, i, BitSlicedPrimitiveArray.getLong(this.bitCount, longs0, sources[i]));
            }
            return longs;
        }

        public Object getObject(Object dataSet, int ordinal) {
            long[] longs = (long[])dataSet;
            int chunksPerWord = 64 / this.bitCount;
            int word = ordinal / chunksPerWord;
            long v = longs[word];
            int chunk = ordinal % chunksPerWord;
            int mask = (1 << this.bitCount) - 1;
            int signMask = 1 << this.bitCount - 1;
            int shift = chunk * this.bitCount;
            long w = v >> shift;
            long x = w & (long)mask;
            if (this.signed && (x & (long)signMask) != 0L) {
                x = -x;
            }
            switch (this.primitive) {
                case BOOLEAN: {
                    return x != 0L;
                }
                case BYTE: {
                    return (byte)x;
                }
                case CHAR: {
                    return Character.valueOf((char)x);
                }
                case SHORT: {
                    return (short)x;
                }
                case INT: {
                    return (int)x;
                }
                case LONG: {
                    return x;
                }
            }
            throw new AssertionError((Object)(this.primitive + " unexpected"));
        }

        public int getInt(Object dataSet, int ordinal) {
            long[] longs = (long[])dataSet;
            int chunksPerWord = 64 / this.bitCount;
            int word = ordinal / chunksPerWord;
            long v = longs[word];
            int chunk = ordinal % chunksPerWord;
            int mask = (1 << this.bitCount) - 1;
            int signMask = 1 << this.bitCount - 1;
            int shift = chunk * this.bitCount;
            long w = v >> shift;
            long x = w & (long)mask;
            if (this.signed && (x & (long)signMask) != 0L) {
                x = -x;
            }
            return (int)x;
        }

        public static long getLong(int bitCount, long[] values, int ordinal) {
            return BitSlicedPrimitiveArray.getLong(bitCount, 64 / bitCount, (1L << bitCount) - 1L, values, ordinal);
        }

        public static long getLong(int bitCount, int chunksPerWord, long mask, long[] values, int ordinal) {
            int word = ordinal / chunksPerWord;
            int chunk = ordinal % chunksPerWord;
            long value = values[word];
            int shift = chunk * bitCount;
            return value >> shift & mask;
        }

        public static void orLong(int bitCount, long[] values, int ordinal, long value) {
            BitSlicedPrimitiveArray.orLong(bitCount, 64 / bitCount, values, ordinal, value);
        }

        public static void orLong(int bitCount, int chunksPerWord, long[] values, int ordinal, long value) {
            int word = ordinal / chunksPerWord;
            int chunk = ordinal % chunksPerWord;
            int shift = chunk * bitCount;
            int n = word;
            values[n] = values[n] | value << shift;
        }

        public int size(Object dataSet) {
            long[] longs = (long[])dataSet;
            int chunksPerWord = 64 / this.bitCount;
            return longs.length * chunksPerWord;
        }

        public String toString(Object dataSet) {
            return Column.asList(this, dataSet).toString();
        }
    }

    public static class Constant
    implements Representation {
        final int ordinal;

        public Constant(int ordinal) {
            this.ordinal = ordinal;
        }

        public String toString() {
            return "Constant(ordinal=" + this.ordinal + ")";
        }

        public RepresentationType getType() {
            return RepresentationType.CONSTANT;
        }

        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            int size = valueSet.values.size();
            return Pair.of(size == 0 ? null : valueSet.values.get(0), size);
        }

        public Object permute(Object dataSet, int[] sources) {
            return dataSet;
        }

        public Object getObject(Object dataSet, int ordinal) {
            Pair pair = (Pair)dataSet;
            return pair.getValue();
        }

        public int getInt(Object dataSet, int ordinal) {
            Pair pair = (Pair)dataSet;
            return ((Number)pair.left).intValue();
        }

        public int size(Object dataSet) {
            Pair pair = (Pair)dataSet;
            return (Integer)pair.right;
        }

        public String toString(Object dataSet) {
            Pair pair = (Pair)dataSet;
            return Collections.nCopies((Integer)pair.right, pair.left).toString();
        }
    }

    public static class ByteStringDictionary
    implements Representation {
        public String toString() {
            return "ByteStringDictionary()";
        }

        public RepresentationType getType() {
            return RepresentationType.BYTE_STRING_DICTIONARY;
        }

        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        public Object permute(Object dataSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        public Object getObject(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        public int getInt(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        public int size(Object dataSet) {
            throw new UnsupportedOperationException();
        }

        public String toString(Object dataSet) {
            return Column.asList(this, dataSet).toString();
        }
    }

    public static class StringDictionary
    implements Representation {
        public String toString() {
            return "StringDictionary()";
        }

        public RepresentationType getType() {
            return RepresentationType.STRING_DICTIONARY;
        }

        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        public Object permute(Object dataSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        public Object getObject(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        public int getInt(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        public int size(Object dataSet) {
            throw new UnsupportedOperationException();
        }

        public String toString(Object dataSet) {
            return Column.asList(this, dataSet).toString();
        }
    }

    public static class ObjectDictionary
    implements Representation {
        final int ordinal;
        final Representation representation;

        public ObjectDictionary(int ordinal, Representation representation) {
            this.ordinal = ordinal;
            this.representation = representation;
        }

        public String toString() {
            return "ObjectDictionary(ordinal=" + this.ordinal + ", representation=" + this.representation + ")";
        }

        public RepresentationType getType() {
            return RepresentationType.OBJECT_DICTIONARY;
        }

        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            int n = valueSet.map.keySet().size();
            int extra = valueSet.containsNull ? 1 : 0;
            Object[] codeValues = valueSet.map.keySet().toArray(new Comparable[n + extra]);
            Arrays.sort(codeValues, 0, n);
            ColumnLoader.ValueSet codeValueSet = new ColumnLoader.ValueSet(Integer.TYPE);
            List list = ArrayTable.permuteList(valueSet.values, sources);
            for (Comparable value : list) {
                int code;
                if (value == null) {
                    code = n;
                } else {
                    code = Arrays.binarySearch(codeValues, value);
                    assert (code >= 0) : code + ", " + value;
                }
                codeValueSet.add(Integer.valueOf(code));
            }
            Object codes = this.representation.freeze(codeValueSet, null);
            return Pair.of(codes, codeValues);
        }

        public Object permute(Object dataSet, int[] sources) {
            Pair pair = (Pair)dataSet;
            Object codes = pair.left;
            Comparable[] codeValues = (Comparable[])pair.right;
            return Pair.of(this.representation.permute(codes, sources), codeValues);
        }

        public Object getObject(Object dataSet, int ordinal) {
            Pair pair = (Pair)dataSet;
            int code = this.representation.getInt(pair.left, ordinal);
            return ((Comparable[])pair.right)[code];
        }

        public int getInt(Object dataSet, int ordinal) {
            return ((Number)this.getObject(dataSet, ordinal)).intValue();
        }

        public int size(Object dataSet) {
            Pair pair = (Pair)dataSet;
            return this.representation.size(pair.left);
        }

        public String toString(Object dataSet) {
            return Column.asList(this, dataSet).toString();
        }
    }

    public static class PrimitiveDictionary
    implements Representation {
        public String toString() {
            return "PrimitiveDictionary()";
        }

        public RepresentationType getType() {
            return RepresentationType.PRIMITIVE_DICTIONARY;
        }

        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        public Object permute(Object dataSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        public Object getObject(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        public int getInt(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        public int size(Object dataSet) {
            throw new UnsupportedOperationException();
        }

        public String toString(Object dataSet) {
            throw new UnsupportedOperationException();
        }
    }

    public static class PrimitiveArray
    implements Representation {
        final int ordinal;
        private final Primitive primitive;
        private final Primitive p;

        public PrimitiveArray(int ordinal, Primitive primitive, Primitive p) {
            this.ordinal = ordinal;
            this.primitive = primitive;
            this.p = p;
        }

        public String toString() {
            return "PrimitiveArray(ordinal=" + this.ordinal + ", primitive=" + this.primitive + ", p=" + this.p + ")";
        }

        public RepresentationType getType() {
            return RepresentationType.PRIMITIVE_ARRAY;
        }

        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            return this.primitive.toArray2((Collection)ArrayTable.permuteList(valueSet.values, sources));
        }

        public Object permute(Object dataSet, int[] sources) {
            return this.primitive.permute(dataSet, sources);
        }

        public Object getObject(Object dataSet, int ordinal) {
            return this.p.arrayItem(dataSet, ordinal);
        }

        public int getInt(Object dataSet, int ordinal) {
            return Array.getInt(dataSet, ordinal);
        }

        public int size(Object dataSet) {
            return Array.getLength(dataSet);
        }

        public String toString(Object dataSet) {
            return this.p.arrayToString(dataSet);
        }
    }

    public static class ObjectArray
    implements Representation {
        final int ordinal;

        public ObjectArray(int ordinal) {
            this.ordinal = ordinal;
        }

        public String toString() {
            return "ObjectArray(ordinal=" + this.ordinal + ")";
        }

        public RepresentationType getType() {
            return RepresentationType.OBJECT_ARRAY;
        }

        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            List list = ArrayTable.permuteList(valueSet.values, sources);
            return list.toArray(new Comparable[list.size()]);
        }

        public Object permute(Object dataSet, int[] sources) {
            Comparable[] list = (Comparable[])dataSet;
            int size = list.length;
            Comparable[] comparables = new Comparable[size];
            for (int i = 0; i < size; ++i) {
                comparables[i] = list[sources[i]];
            }
            return comparables;
        }

        public Object getObject(Object dataSet, int ordinal) {
            return ((Comparable[])dataSet)[ordinal];
        }

        public int getInt(Object dataSet, int ordinal) {
            return ((Number)this.getObject(dataSet, ordinal)).intValue();
        }

        public int size(Object dataSet) {
            return ((Comparable[])dataSet).length;
        }

        public String toString(Object dataSet) {
            return Arrays.toString((Comparable[])dataSet);
        }
    }

    public static interface Representation {
        public RepresentationType getType();

        public Object freeze(ColumnLoader.ValueSet var1, int[] var2);

        public Object getObject(Object var1, int var2);

        public int getInt(Object var1, int var2);

        public Object permute(Object var1, int[] var2);

        public int size(Object var1);

        public String toString(Object var1);
    }

    public static class Column {
        final Representation representation;
        final Object dataSet;
        final int cardinality;

        Column(Representation representation, Object data, int cardinality) {
            this.representation = representation;
            this.dataSet = data;
            this.cardinality = cardinality;
        }

        public Column permute(int[] sources) {
            return new Column(this.representation, this.representation.permute(this.dataSet, sources), this.cardinality);
        }

        public String toString() {
            return "Column(representation=" + this.representation + ", value=" + this.representation.toString(this.dataSet) + ")";
        }

        public static List asList(final Representation representation, final Object dataSet) {
            final int size = representation.size(dataSet);
            return new AbstractList(){

                public Object get(int index) {
                    return representation.getObject(dataSet, index);
                }

                public int size() {
                    return size;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RepresentationType {
        CONSTANT,
        OBJECT_ARRAY,
        PRIMITIVE_ARRAY,
        BIT_SLICED_PRIMITIVE_ARRAY,
        PRIMITIVE_DICTIONARY,
        OBJECT_DICTIONARY,
        STRING_DICTIONARY,
        BYTE_STRING_DICTIONARY;

    }
}

