/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.version;

import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteOrder;

public final class ODistributedVersion
implements ORecordVersion {
    public static final int STREAMED_SIZE = 20;
    public static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    private int counter;
    private long timestamp;
    private long macAddress;

    public ODistributedVersion() {
    }

    public ODistributedVersion(int counter) {
        this.counter = counter;
        this.timestamp = System.currentTimeMillis();
        this.macAddress = OVersionFactory.instance().getMacAddress();
    }

    public ODistributedVersion(int counter, long timestamp, long macAddress) {
        this.counter = counter;
        this.timestamp = timestamp;
        this.macAddress = macAddress;
    }

    @Override
    public void increment() {
        if (this.isTombstone()) {
            throw new IllegalStateException("Record was deleted and can not be updated.");
        }
        ++this.counter;
        this.timestamp = System.currentTimeMillis();
        this.macAddress = OVersionFactory.instance().getMacAddress();
    }

    @Override
    public void decrement() {
        if (this.isTombstone()) {
            throw new IllegalStateException("Record was deleted and can not be updated.");
        }
        --this.counter;
        this.timestamp = System.currentTimeMillis();
        this.macAddress = OVersionFactory.instance().getMacAddress();
    }

    @Override
    public boolean isUntracked() {
        return this.counter == -1;
    }

    @Override
    public boolean isTemporary() {
        return this.counter < -1;
    }

    @Override
    public boolean isValid() {
        return this.counter > -1;
    }

    @Override
    public void setCounter(int iVersion) {
        this.counter = iVersion;
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    @Override
    public boolean isTombstone() {
        return this.counter < 0;
    }

    @Override
    public void convertToTombstone() {
        if (this.isTombstone()) {
            throw new IllegalStateException("Record was deleted and can not be updated.");
        }
        ++this.counter;
        this.counter = -this.counter;
        this.timestamp = System.currentTimeMillis();
        this.macAddress = OVersionFactory.instance().getMacAddress();
    }

    @Override
    public byte[] toStream() {
        byte[] buffer = new byte[20];
        this.getSerializer().writeTo(buffer, 0, (ORecordVersion)this);
        return buffer;
    }

    @Override
    public void fromStream(byte[] stream) {
        this.getSerializer().readFrom(stream, 0, (ORecordVersion)this);
    }

    @Override
    public void copyFrom(ORecordVersion version) {
        ODistributedVersion other = (ODistributedVersion)version;
        this.update(other.counter, other.timestamp, other.macAddress);
    }

    public void update(int recordVersion, long timestamp, long macAddress) {
        this.counter = recordVersion;
        this.timestamp = timestamp;
        this.macAddress = macAddress;
    }

    @Override
    public void reset() {
        this.counter = 0;
        this.timestamp = System.currentTimeMillis();
        this.macAddress = OVersionFactory.instance().getMacAddress();
    }

    @Override
    public void setRollbackMode() {
        this.counter = Integer.MIN_VALUE + this.counter;
    }

    @Override
    public void clearRollbackMode() {
        this.counter -= Integer.MIN_VALUE;
    }

    @Override
    public void disable() {
        this.counter = -1;
    }

    @Override
    public void revive() {
        this.counter = -this.counter;
    }

    @Override
    public ORecordVersion copy() {
        ODistributedVersion copy = new ODistributedVersion();
        copy.counter = this.counter;
        copy.timestamp = this.timestamp;
        copy.macAddress = this.macAddress;
        return copy;
    }

    @Override
    public ORecordVersion.ORecordVersionSerializer getSerializer() {
        return ODistributedVersionSerializer.INSTANCE;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ODistributedVersion && ((ODistributedVersion)other).compareTo(this) == 0;
    }

    @Override
    public int hashCode() {
        int result = this.counter;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.macAddress ^ this.macAddress >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return ODistributedVersionSerializer.INSTANCE.toString(this);
    }

    @Override
    public int compareTo(ORecordVersion o) {
        int otherCounter;
        ODistributedVersion other = (ODistributedVersion)o;
        int myCounter = this.isTombstone() ? -this.counter : this.counter;
        if (myCounter != (otherCounter = o.isTombstone() ? -o.getCounter() : o.getCounter())) {
            return myCounter > otherCounter ? 1 : -1;
        }
        if (this.timestamp != other.timestamp) {
            return this.timestamp > other.timestamp ? 1 : -1;
        }
        if (this.macAddress > other.macAddress) {
            return 1;
        }
        if (this.macAddress < other.macAddress) {
            return -1;
        }
        return 0;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getMacAddress() {
        return this.macAddress;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ODistributedVersionSerializer.INSTANCE.writeTo(out, (ORecordVersion)this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ODistributedVersionSerializer.INSTANCE.readFrom(in, (ORecordVersion)this);
    }

    private static final class ODistributedVersionSerializer
    implements ORecordVersion.ORecordVersionSerializer {
        private static final ODistributedVersionSerializer INSTANCE = new ODistributedVersionSerializer();

        private ODistributedVersionSerializer() {
        }

        @Override
        public void writeTo(DataOutput out, ORecordVersion version) throws IOException {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            out.writeInt(distributedVersion.counter);
            out.writeLong(distributedVersion.timestamp);
            out.writeLong(distributedVersion.macAddress);
        }

        @Override
        public void readFrom(DataInput in, ORecordVersion version) throws IOException {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            distributedVersion.counter = in.readInt();
            distributedVersion.timestamp = in.readLong();
            distributedVersion.macAddress = in.readLong();
        }

        @Override
        public void writeTo(OutputStream stream, ORecordVersion version) throws IOException {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            OBinaryProtocol.int2bytes(distributedVersion.counter, stream);
            OBinaryProtocol.long2bytes(distributedVersion.timestamp, stream);
            OBinaryProtocol.long2bytes(distributedVersion.macAddress, stream);
        }

        @Override
        public void readFrom(InputStream stream, ORecordVersion version) throws IOException {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            distributedVersion.counter = OBinaryProtocol.bytes2int(stream);
            distributedVersion.timestamp = OBinaryProtocol.bytes2long(stream);
            distributedVersion.macAddress = OBinaryProtocol.bytes2long(stream);
        }

        @Override
        public int writeTo(byte[] stream, int pos, ORecordVersion version) {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            int len = 0;
            OBinaryProtocol.int2bytes(distributedVersion.counter, stream, pos + len);
            OBinaryProtocol.long2bytes(distributedVersion.timestamp, stream, pos + (len += 4));
            OBinaryProtocol.long2bytes(distributedVersion.macAddress, stream, pos + (len += 8));
            return len += 8;
        }

        @Override
        public int readFrom(byte[] iStream, int pos, ORecordVersion version) {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            int len = 0;
            distributedVersion.counter = OBinaryProtocol.bytes2int(iStream, pos + len);
            distributedVersion.timestamp = OBinaryProtocol.bytes2long(iStream, pos + (len += 4));
            distributedVersion.macAddress = OBinaryProtocol.bytes2long(iStream, pos + (len += 8));
            return len += 8;
        }

        @Override
        public int writeTo(OFile file, long pos, ORecordVersion version) throws IOException {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            int len = 0;
            file.writeInt(pos + (long)len, distributedVersion.counter);
            file.writeLong(pos + (long)(len += 4), distributedVersion.timestamp);
            file.writeLong(pos + (long)(len += 8), distributedVersion.macAddress);
            return len += 8;
        }

        @Override
        public long readFrom(OFile file, long pos, ORecordVersion version) throws IOException {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            int len = 0;
            distributedVersion.counter = file.readInt(pos + (long)len);
            distributedVersion.timestamp = file.readLong(pos + (long)(len += 4));
            distributedVersion.macAddress = file.readLong(pos + (long)(len += 8));
            return len += 8;
        }

        @Override
        public int fastWriteTo(byte[] iStream, int pos, ORecordVersion version) {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            int len = 0;
            CONVERTER.putInt(iStream, pos + len, distributedVersion.counter, ByteOrder.nativeOrder());
            CONVERTER.putLong(iStream, pos + (len += 4), distributedVersion.timestamp, ByteOrder.nativeOrder());
            CONVERTER.putLong(iStream, pos + (len += 8), distributedVersion.macAddress, ByteOrder.nativeOrder());
            return len += 8;
        }

        @Override
        public int fastReadFrom(byte[] iStream, int pos, ORecordVersion version) {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            int len = 0;
            distributedVersion.counter = CONVERTER.getInt(iStream, pos + len, ByteOrder.nativeOrder());
            distributedVersion.timestamp = CONVERTER.getLong(iStream, pos + (len += 4), ByteOrder.nativeOrder());
            distributedVersion.macAddress = CONVERTER.getLong(iStream, pos + (len += 8), ByteOrder.nativeOrder());
            return len += 8;
        }

        @Override
        public byte[] toByteArray(ORecordVersion version) {
            int size = 20;
            byte[] buffer = new byte[size];
            this.fastWriteTo(buffer, 0, version);
            return buffer;
        }

        @Override
        public String toString(ORecordVersion version) {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            return distributedVersion.counter + "." + distributedVersion.timestamp + "." + distributedVersion.macAddress;
        }

        @Override
        public void fromString(String string, ORecordVersion version) {
            ODistributedVersion distributedVersion = (ODistributedVersion)version;
            String[] parts = string.split("\\.");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Not correct format of distributed version. Expected <recordVersion>.<timestamp>.<macAddress>");
            }
            distributedVersion.counter = Integer.valueOf(parts[0]);
            distributedVersion.timestamp = Long.valueOf(parts[1]);
            distributedVersion.macAddress = Long.valueOf(parts[2]);
        }
    }
}

