/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OLimitedMap;
import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.memory.OLowMemoryException;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.profiler.OJVMProfiler;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class OMVRBTreePersistent<K, V>
extends OMVRBTree<K, V> {
    protected OMVRBTreeProvider<K, V> dataProvider;
    protected ORecord<?> owner;
    protected final Set<OMVRBTreeEntryPersistent<K, V>> recordsToCommit = new HashSet<OMVRBTreeEntryPersistent<K, V>>();
    protected volatile int optimization = 0;
    protected int entryPointsSize;
    protected float optimizeEntryPointsFactor;
    private final TreeMap<K, OMVRBTreeEntryPersistent<K, V>> entryPoints;
    private final Map<ORID, OMVRBTreeEntryPersistent<K, V>> cache = new OLimitedMap<ORID, OMVRBTreeEntryPersistent<K, V>>(256, 0.9f, OGlobalConfiguration.MVRBTREE_OPTIMIZE_THRESHOLD.getValueAsInteger()){

        protected boolean removeEldestEntry(Map.Entry<ORID, OMVRBTreeEntryPersistent<K, V>> eldest) {
            if (super.removeEldestEntry(eldest)) {
                OMVRBTreePersistent.this.setOptimization(2);
            }
            return false;
        }
    };
    protected static final OJVMProfiler PROFILER = Orient.instance().getProfiler();
    private static final int OPTIMIZE_MAX_RETRY = 10;

    public OMVRBTreePersistent(OMVRBTreeProvider<K, V> iProvider) {
        this.entryPoints = this.comparator != null ? new TreeMap(this.comparator) : new TreeMap();
        this.pageLoadFactor = ((Float)OGlobalConfiguration.MVRBTREE_LOAD_FACTOR.getValue()).floatValue();
        this.dataProvider = iProvider;
        this.config();
    }

    public OMVRBTreePersistent(OMVRBTreeProvider<K, V> iProvider, int keySize) {
        this(iProvider);
        this.keySize = keySize;
        this.dataProvider.setKeySize(keySize);
    }

    protected OMVRBTreeEntryPersistent<K, V> createEntry(OMVRBTreeEntry<K, V> iParent) {
        this.adjustPageSize();
        return new OMVRBTreeEntryPersistent<K, V>(iParent, iParent.getPageSplitItems());
    }

    protected OMVRBTreeEntryPersistent<K, V> createEntry(K key, V value) {
        this.adjustPageSize();
        return new OMVRBTreeEntryPersistent<K, V>(this, key, value, null);
    }

    protected OMVRBTreeEntryPersistent<K, V> createEntry(OMVRBTreeEntryPersistent<K, V> iParent, ORID iRecordId) {
        return new OMVRBTreeEntryPersistent<K, V>(this, iParent, iRecordId);
    }

    public OMVRBTreePersistent<K, V> load() {
        this.dataProvider.load();
        this.setLastSearchNode(null, null);
        this.keySize = this.dataProvider.getKeySize();
        ORID rootRid = this.dataProvider.getRoot();
        if (rootRid != null && rootRid.isValid()) {
            this.root = this.loadEntry(null, rootRid);
        }
        return this;
    }

    protected void initAfterLoad() throws IOException {
    }

    public OMVRBTreePersistent<K, V> save() {
        this.commitChanges();
        return this;
    }

    protected void saveTreeNode() throws IOException {
        OMVRBTreeEntryPersistent pRoot;
        if (this.root != null && (pRoot = (OMVRBTreeEntryPersistent)this.root).getProvider().getIdentity().isNew()) {
            pRoot.save();
        }
        this.dataProvider.save();
    }

    protected OMVRBTreeEntryPersistent<K, V> loadEntry(OMVRBTreeEntryPersistent<K, V> iParent, ORID iRecordId) {
        OMVRBTreeEntryPersistent<K, V> entry = this.searchNodeInCache(iRecordId);
        if (entry == null) {
            OMVRBTreeEntryPersistent<K, V> rightNode;
            OMVRBTreeEntryPersistent<K, V> leftNode;
            OMVRBTreeEntryPersistent<K, V> parentNode;
            entry = this.createEntry(iParent, iRecordId);
            this.addNodeInMemory(entry);
            if (entry.parent == null && entry.dataProvider.getParent().isValid() && (parentNode = this.searchNodeInCache(entry.dataProvider.getParent())) != null) {
                entry.setParent(parentNode);
            }
            if (entry.left == null && entry.dataProvider.getLeft().isValid() && (leftNode = this.searchNodeInCache(entry.dataProvider.getLeft())) != null) {
                entry.setLeft(leftNode);
            }
            if (entry.right == null && entry.dataProvider.getRight().isValid() && (rightNode = this.searchNodeInCache(entry.dataProvider.getRight())) != null) {
                entry.setRight(rightNode);
            }
        } else if (iParent != null) {
            entry.setParent(iParent);
        }
        entry.checkEntryStructure();
        return entry;
    }

    protected int getTreeSize() {
        return this.dataProvider.getSize();
    }

    protected void setSize(int iSize) {
        if (this.dataProvider.setSize(iSize)) {
            this.markDirty();
        }
    }

    public int getDefaultPageSize() {
        return this.dataProvider.getDefaultPageSize();
    }

    public void clear() {
        long timer = PROFILER.startChrono();
        try {
            this.recordsToCommit.clear();
            this.entryPoints.clear();
            this.cache.clear();
            if (this.root != null) {
                try {
                    ((OMVRBTreeEntryPersistent)this.root).delete();
                }
                catch (Exception e) {
                    this.dataProvider = this.dataProvider.copy();
                }
            }
            super.clear();
            this.markDirty();
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.clear"), "Clear a MVRBTree", timer);
        }
    }

    public void delete() {
        this.clear();
        this.dataProvider.delete();
    }

    public void unload() {
        block8: {
            long timer = PROFILER.startChrono();
            try {
                try {
                    for (OMVRBTreeEntryPersistent<K, V> entryPoint : this.entryPoints.values()) {
                        entryPoint.disconnectLinked(true);
                    }
                    this.entryPoints.clear();
                    this.cache.clear();
                    this.recordsToCommit.clear();
                    this.root = null;
                    ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
                    if (db == null || db.isClosed() || !(db.getStorage() instanceof OStorageEmbedded)) break block8;
                    try {
                        this.load();
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on unload the tree: " + this.dataProvider, (Throwable)e, OStorageException.class, new Object[0]);
                    PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.unload"), "Unload a MVRBTree", timer);
                }
            }
            finally {
                PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.unload"), "Unload a MVRBTree", timer);
            }
        }
    }

    protected void optimize() {
        this.optimize(false);
    }

    /*
     * Exception decompiling
     */
    public int optimize(boolean iForce) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public OMVRBTreeEntry<K, V> getCeilingEntry(K key, OMVRBTree.PartialSearchMode partialSearchMode) {
        int i = 0;
        while (i < 10) {
            try {
                return super.getCeilingEntry(key, partialSearchMode);
            }
            catch (OLowMemoryException e) {
                OLogManager.instance().debug((Object)this, "Optimization required during node search %d/%d", new Object[]{i, 10});
                this.freeMemory(i);
                ++i;
            }
        }
        throw new OLowMemoryException("OMVRBTreePersistent.getCeilingEntry()");
    }

    public OMVRBTreeEntry<K, V> getFloorEntry(K key, OMVRBTree.PartialSearchMode partialSearchMode) {
        int i = 0;
        while (i < 10) {
            try {
                return super.getFloorEntry(key, partialSearchMode);
            }
            catch (OLowMemoryException e) {
                OLogManager.instance().debug((Object)this, "Optimization required during node search %d/%d", new Object[]{i, 10});
                this.freeMemory(i);
                ++i;
            }
        }
        throw new OLowMemoryException("OMVRBTreePersistent.getFloorEntry()");
    }

    public OMVRBTreeEntry<K, V> getHigherEntry(K key) {
        int i = 0;
        while (i < 10) {
            try {
                return super.getHigherEntry(key);
            }
            catch (OLowMemoryException e) {
                OLogManager.instance().debug((Object)this, "Optimization required during node search %d/%d", new Object[]{i, 10});
                this.freeMemory(i);
                ++i;
            }
        }
        throw new OLowMemoryException("OMVRBTreePersistent.getHigherEntry)");
    }

    public OMVRBTreeEntry<K, V> getLowerEntry(K key) {
        int i = 0;
        while (i < 10) {
            try {
                return super.getLowerEntry(key);
            }
            catch (OLowMemoryException e) {
                OLogManager.instance().debug((Object)this, "Optimization required during node search %d/%d", new Object[]{i, 10});
                this.freeMemory(i);
                ++i;
            }
        }
        throw new OLowMemoryException("OMVRBTreePersistent.getLowerEntry()");
    }

    public V put(K key, V value) {
        this.optimize();
        long timer = PROFILER.startChrono();
        try {
            V v = this.internalPut(key, value);
            this.commitChanges();
            V v2 = v;
            return v2;
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.put"), "Put a value into a MVRBTree", timer);
        }
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        long timer = PROFILER.startChrono();
        try {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.internalPut(entry.getKey(), entry.getValue());
            }
            this.commitChanges();
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.putAll"), "Put multiple values into a MVRBTree", timer);
        }
    }

    public V remove(Object key) {
        this.optimize();
        long timer = PROFILER.startChrono();
        try {
            int i = 0;
            while (i < 10) {
                Object object;
                try {
                    Object v = super.remove(key);
                    this.commitChanges();
                    object = v;
                }
                catch (OLowMemoryException e) {
                    OLogManager.instance().debug((Object)this, "Optimization required during remove %d/%d", new Object[]{i, 10});
                    this.freeMemory(i);
                    this.optimization = -1;
                    ++i;
                    continue;
                }
                return (V)object;
            }
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.remove"), "Remove a value from a MVRBTree", timer);
        }
        throw new OLowMemoryException("OMVRBTreePersistent.remove()");
    }

    public int commitChanges() {
        long timer = PROFILER.startChrono();
        int totalCommitted = 0;
        try {
            try {
                if (!this.recordsToCommit.isEmpty()) {
                    ArrayList<OMVRBTreeEntryPersistent<K, V>> tmp = new ArrayList<OMVRBTreeEntryPersistent<K, V>>();
                    while (this.recordsToCommit.iterator().hasNext()) {
                        tmp.addAll(this.recordsToCommit);
                        this.recordsToCommit.clear();
                        for (OMVRBTreeEntryPersistent oMVRBTreeEntryPersistent : tmp) {
                            if (!oMVRBTreeEntryPersistent.dataProvider.isEntryDirty()) continue;
                            boolean wasNew = oMVRBTreeEntryPersistent.dataProvider.getIdentity().isNew();
                            oMVRBTreeEntryPersistent.save();
                            if (!this.debug) continue;
                            System.out.printf("\nSaved %s tree node %s: parent %s, left %s, right %s", wasNew ? "new" : "", oMVRBTreeEntryPersistent.dataProvider.getIdentity(), oMVRBTreeEntryPersistent.dataProvider.getParent(), oMVRBTreeEntryPersistent.dataProvider.getLeft(), oMVRBTreeEntryPersistent.dataProvider.getRight());
                        }
                        totalCommitted += tmp.size();
                        tmp.clear();
                    }
                }
                if (this.dataProvider.isDirty()) {
                    this.saveTreeNode();
                }
            }
            catch (IOException e) {
                OLogManager.instance().exception("Error on saving the tree", (Exception)e, OStorageException.class, new Object[0]);
                PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.commitChanges"), "Commit pending changes to a MVRBTree", timer);
            }
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.commitChanges"), "Commit pending changes to a MVRBTree", timer);
        }
        return totalCommitted;
    }

    public void signalNodeChanged(OMVRBTreeEntry<K, V> iNode) {
        this.recordsToCommit.add((OMVRBTreeEntryPersistent)iNode);
    }

    public int hashCode() {
        return this.dataProvider.hashCode();
    }

    protected void adjustPageSize() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public V get(Object iKey) {
        long timer = PROFILER.startChrono();
        try {
            int i = 0;
            while (i < 10) {
                Object object;
                try {
                    object = super.get(iKey);
                }
                catch (OLowMemoryException e) {
                    try {
                        OLogManager.instance().debug((Object)this, "Optimization required during node search %d/%d", new Object[]{i, 10});
                        this.freeMemory(i);
                        ++i;
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        throw new OLowMemoryException("OMVRBTreePersistent.get()");
                    }
                }
                return (V)object;
            }
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.get"), "Get a value from a MVRBTree", timer);
        }
    }

    public boolean containsKey(Object iKey) {
        int i = 0;
        while (i < 10) {
            try {
                return super.containsKey(iKey);
            }
            catch (OLowMemoryException e) {
                OLogManager.instance().debug((Object)this, "Optimization required during node search %d/%d", new Object[]{i, 10});
                this.freeMemory(i);
                ++i;
            }
        }
        throw new OLowMemoryException("OMVRBTreePersistent.containsKey()");
    }

    public boolean containsValue(Object iValue) {
        int i = 0;
        while (i < 10) {
            try {
                return super.containsValue(iValue);
            }
            catch (OLowMemoryException e) {
                OLogManager.instance().debug((Object)this, "Optimization required during node search %d/%d", new Object[]{i, 10});
                this.freeMemory(i);
                ++i;
            }
        }
        throw new OLowMemoryException("OMVRBTreePersistent.containsValue()");
    }

    public OMVRBTreeProvider<K, V> getProvider() {
        return this.dataProvider;
    }

    public int getOptimization() {
        return this.optimization;
    }

    public void setOptimization(int iMode) {
        if (iMode > 0 && this.optimization == -1) {
            return;
        }
        this.optimization = iMode;
    }

    protected void searchNodeCallback() {
        if (this.optimization > 0) {
            throw new OLowMemoryException("Optimization level: " + this.optimization);
        }
    }

    public int getEntryPointSize() {
        return this.entryPointsSize;
    }

    public void setEntryPointSize(int entryPointSize) {
        this.entryPointsSize = entryPointSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder().append('[');
        if (this.size() < 10) {
            OMVRBTreeEntry current = this.getFirstEntry();
            int i = 0;
            while (i < 10 && current != null) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(current);
                current = OMVRBTreePersistent.next(current);
                ++i;
            }
        } else {
            buffer.append("size=");
            int size = this.size();
            buffer.append(size);
            OMVRBTreeEntry<K, V> firstEntry = this.getFirstEntry();
            if (firstEntry != null) {
                int currPageIndex = this.pageIndex;
                buffer.append(" ");
                buffer.append(firstEntry.getFirstKey());
                if (size > 1) {
                    buffer.append("-");
                    buffer.append(this.getLastEntry().getLastKey());
                }
                this.pageIndex = currPageIndex;
            }
        }
        return buffer.append(']').toString();
    }

    protected V internalPut(K key, V value) throws OLowMemoryException {
        ORecordInternal rec;
        if (key instanceof ORecordInternal && !(rec = (ORecordInternal)key).getIdentity().isValid()) {
            rec.save();
        }
        if (value instanceof ORecordInternal && !(rec = (ORecordInternal)value).getIdentity().isValid()) {
            rec.save();
        }
        int i = 0;
        while (i < 10) {
            try {
                return (V)super.put(key, value);
            }
            catch (OLowMemoryException e) {
                OLogManager.instance().debug((Object)this, "Optimization required during put %d/%d", new Object[]{i, 10});
                this.freeMemory(i);
                ++i;
            }
        }
        throw new OLowMemoryException("OMVRBTreePersistent.put()");
    }

    protected OMVRBTreeEntry<K, V> getBestEntryPoint(K iKey) {
        if (!this.entryPoints.isEmpty()) {
            Map.Entry<K, OMVRBTreeEntryPersistent<K, Object>> closerNode = this.entryPoints.floorEntry(iKey);
            if (closerNode != null) {
                return closerNode.getValue();
            }
            closerNode = this.entryPoints.ceilingEntry(iKey);
            if (closerNode != null) {
                return closerNode.getValue();
            }
        }
        return super.getBestEntryPoint(iKey);
    }

    void removeEntryPoint(OMVRBTreeEntryPersistent<K, V> iEntry) {
        this.entryPoints.remove(iEntry);
    }

    synchronized void removeEntry(ORID iEntryId) {
        for (OMVRBTreeEntryPersistent<K, V> node : this.recordsToCommit) {
            if (!node.dataProvider.getIdentity().equals(iEntryId)) continue;
            this.recordsToCommit.remove(node);
            break;
        }
    }

    public OMVRBTreeEntry<K, V> getFirstEntry() {
        Map.Entry<K, OMVRBTreeEntryPersistent<K, V>> entry;
        if (!this.entryPoints.isEmpty() && (entry = this.entryPoints.firstEntry()) != null) {
            OMVRBTreeEntryPersistent prev;
            OMVRBTreeEntryPersistent e = entry.getValue();
            do {
                if ((prev = (OMVRBTreeEntryPersistent)OMVRBTreePersistent.predecessor(e)) == null) continue;
                e = prev;
            } while (prev != null);
            if (e != null && e.getSize() > 0) {
                this.pageIndex = 0;
            }
            return e;
        }
        return super.getFirstEntry();
    }

    protected OMVRBTreeEntry<K, V> getLastEntry() {
        Map.Entry<K, OMVRBTreeEntryPersistent<K, V>> entry;
        if (!this.entryPoints.isEmpty() && (entry = this.entryPoints.lastEntry()) != null) {
            OMVRBTreeEntryPersistent next;
            OMVRBTreeEntryPersistent e = entry.getValue();
            do {
                if ((next = (OMVRBTreeEntryPersistent)OMVRBTreePersistent.successor(e)) == null) continue;
                e = next;
            } while (next != null);
            if (e != null && e.getSize() > 0) {
                this.pageIndex = e.getSize() - 1;
            }
            return e;
        }
        return super.getLastEntry();
    }

    protected void setRoot(OMVRBTreeEntry<K, V> iRoot) {
        if (iRoot == this.root) {
            return;
        }
        super.setRoot(iRoot);
        if (iRoot == null) {
            this.dataProvider.setRoot(null);
        } else {
            this.dataProvider.setRoot(((OMVRBTreeEntryPersistent)iRoot).getProvider().getIdentity());
        }
    }

    protected void config() {
        if (this.dataProvider.updateConfig()) {
            this.markDirty();
        }
        this.pageLoadFactor = OGlobalConfiguration.MVRBTREE_LOAD_FACTOR.getValueAsFloat();
        this.optimizeEntryPointsFactor = OGlobalConfiguration.MVRBTREE_OPTIMIZE_ENTRYPOINTS_FACTOR.getValueAsFloat();
        this.entryPointsSize = OGlobalConfiguration.MVRBTREE_ENTRYPOINTS.getValueAsInteger();
    }

    protected void rotateLeft(OMVRBTreeEntry<K, V> p) {
        if (this.debug && p != null) {
            System.out.printf("\nRotating to the left the node %s", ((OMVRBTreeEntryPersistent)p).dataProvider.getIdentity());
        }
        super.rotateLeft(p);
    }

    protected void rotateRight(OMVRBTreeEntry<K, V> p) {
        if (this.debug && p != null) {
            System.out.printf("\nRotating to the right the node %s", ((OMVRBTreeEntryPersistent)p).dataProvider.getIdentity());
        }
        super.rotateRight(p);
    }

    protected OMVRBTreeEntry<K, V> removeNode(OMVRBTreeEntry<K, V> p) {
        OMVRBTreeEntryPersistent removed = (OMVRBTreeEntryPersistent)super.removeNode(p);
        this.removeNodeFromMemory(removed);
        if (removed.getProvider() != null) {
            removed.getProvider().delete();
        }
        this.recordsToCommit.remove(removed);
        return removed;
    }

    protected void removeNodeFromMemory(OMVRBTreeEntryPersistent<K, V> iNode) {
        if (iNode.dataProvider != null && iNode.dataProvider.getIdentity().isValid()) {
            this.cache.remove(iNode.dataProvider.getIdentity());
        }
        if (iNode.getSize() > 0) {
            this.entryPoints.remove(iNode.getKeyAt(0));
        }
    }

    protected void addNodeInMemory(OMVRBTreeEntryPersistent<K, V> iNode) {
        this.addNodeAsEntrypoint(iNode);
        this.addNodeInCache(iNode);
    }

    protected boolean isNodeEntryPoint(OMVRBTreeEntryPersistent<K, V> iNode) {
        if (iNode != null && iNode.getSize() > 0) {
            return this.entryPoints.containsKey(iNode.getKeyAt(0));
        }
        return false;
    }

    protected void addNodeAsEntrypoint(OMVRBTreeEntryPersistent<K, V> iNode) {
        if (iNode != null && iNode.getSize() > 0) {
            this.entryPoints.put(iNode.getKeyAt(0), iNode);
        }
    }

    protected void updateEntryPoint(K iOldKey, OMVRBTreeEntryPersistent<K, V> iNode) {
        OMVRBTreeEntryPersistent<K, V> node = this.entryPoints.remove(iOldKey);
        if (node != null) {
            if (node != iNode) {
                OLogManager.instance().warn((Object)this, "Entrypoints nodes are different during update: old %s <-> new %s", new Object[]{node, iNode});
            }
            this.addNodeAsEntrypoint(iNode);
        }
    }

    protected void addNodeInCache(OMVRBTreeEntryPersistent<K, V> iNode) {
        if (iNode.dataProvider != null && iNode.dataProvider.getIdentity().isValid()) {
            this.cache.put(iNode.dataProvider.getIdentity(), iNode);
        }
    }

    protected OMVRBTreeEntryPersistent<K, V> searchNodeInCache(ORID iRid) {
        return this.cache.get(iRid);
    }

    public int getNumberOfNodesInCache() {
        return this.cache.size();
    }

    protected Set<ORID> getAllNodesInCache() {
        return this.cache.keySet();
    }

    protected void removeNodeFromCache(ORID iRid) {
        this.cache.remove(iRid);
    }

    protected void markDirty() {
    }

    public ORecord<?> getOwner() {
        return this.owner;
    }

    public OMVRBTreePersistent<K, V> setOwner(ORecord<?> owner) {
        this.owner = owner;
        return this;
    }

    protected void freeMemory(int i) {
        this.optimize(true);
        OMemoryWatchDog.freeMemoryForOptimization(300 * i);
    }
}

