/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.List;

public interface OTransaction {
    public void begin();

    public void commit();

    public void rollback();

    public ODatabaseRecordTx getDatabase();

    public void clearRecordEntries();

    public ORecordInternal<?> loadRecord(ORID var1, ORecordInternal<?> var2, String var3, boolean var4, boolean var5);

    public boolean updateReplica(ORecordInternal<?> var1);

    public void saveRecord(ORecordInternal<?> var1, String var2, ODatabaseComplex.OPERATION_MODE var3, boolean var4, ORecordCallback<? extends Number> var5, ORecordCallback<ORecordVersion> var6);

    public void deleteRecord(ORecordInternal<?> var1, ODatabaseComplex.OPERATION_MODE var2);

    public int getId();

    public TXSTATUS getStatus();

    public Iterable<? extends ORecordOperation> getCurrentRecordEntries();

    public Iterable<? extends ORecordOperation> getAllRecordEntries();

    public List<ORecordOperation> getRecordEntriesByClass(String var1);

    public List<ORecordOperation> getNewRecordEntriesByClusterIds(int[] var1);

    public ORecordInternal<?> getRecord(ORID var1);

    public ORecordOperation getRecordEntry(ORID var1);

    public List<String> getInvolvedIndexes();

    public ODocument getIndexChanges();

    public void addIndexEntry(OIndex<?> var1, String var2, OTransactionIndexChanges.OPERATION var3, Object var4, OIdentifiable var5);

    public void clearIndexEntries();

    public OTransactionIndexChanges getIndexChanges(String var1);

    public boolean isActive();

    public boolean isUsingLog();

    public void setUsingLog(boolean var1);

    public void close();

    public void updateIdentityAfterCommit(ORID var1, ORID var2);

    public static enum TXSTATUS {
        INVALID,
        BEGUN,
        COMMITTING,
        ROLLBACKING;

    }

    public static enum TXTYPE {
        NOTX,
        OPTIMISTIC,
        PESSIMISTIC;

    }
}

