/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;

public abstract class OClusterMemory
extends OSharedResourceAdaptive
implements OCluster {
    public static final String TYPE = "MEMORY";
    private OStorage storage;
    private int id;
    private String name;
    private int dataSegmentId;

    public OClusterMemory() {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
    }

    @Override
    public void configure(OStorage iStorage, OStorageClusterConfiguration iConfig) throws IOException {
        this.configure(iStorage, iConfig.getId(), iConfig.getName(), iConfig.getLocation(), iConfig.getDataSegmentId(), new Object[0]);
    }

    @Override
    public void configure(OStorage iStorage, int iId, String iClusterName, String iLocation, int iDataSegmentId, Object ... iParameters) {
        this.storage = iStorage;
        this.id = iId;
        this.name = iClusterName;
        this.dataSegmentId = iDataSegmentId;
    }

    @Override
    public int getDataSegmentId() {
        this.acquireSharedLock();
        try {
            int n = this.dataSegmentId;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean useWal() {
        return false;
    }

    @Override
    public float recordGrowFactor() {
        return 1.0f;
    }

    @Override
    public float recordOverflowGrowFactor() {
        return 1.0f;
    }

    @Override
    public String compression() {
        return "nothing";
    }

    @Override
    public OClusterEntryIterator absoluteIterator() {
        return new OClusterEntryIterator(this);
    }

    @Override
    public void close() {
        this.acquireExclusiveLock();
        try {
            this.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void create(int iStartSize) throws IOException {
    }

    @Override
    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.close();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void truncate() throws IOException {
        this.storage.checkForClusterPermissions(this.getName());
        this.acquireExclusiveLock();
        try {
            this.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void set(OCluster.ATTRIBUTES iAttribute, Object iValue) throws IOException {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (iAttribute) {
            case NAME: {
                this.name = stringValue;
                break;
            }
            case DATASEGMENT: {
                this.dataSegmentId = this.storage.getDataSegmentIdByName(stringValue);
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void synch() {
    }

    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
    }

    @Override
    public boolean wasSoftlyClosed() throws IOException {
        return true;
    }

    @Override
    public void lock() {
        this.acquireSharedLock();
    }

    @Override
    public void unlock() {
        this.releaseSharedLock();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    protected abstract void clear();
}

