/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractPageWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OBinaryFullPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OBinaryPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OIntFullPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OIntPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OLongFullPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OLongPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OPageDiff;
import java.util.ArrayList;
import java.util.List;

public class OUpdatePageRecord
extends OAbstractPageWALRecord {
    private List<OPageDiff<?>> diffs = new ArrayList();
    private OLogSequenceNumber prevLsn;

    public OUpdatePageRecord() {
    }

    public OUpdatePageRecord(long pageIndex, int clusterId, OOperationUnitId operationUnitId, List<OPageDiff<?>> diffs, OLogSequenceNumber prevLsn) {
        super(pageIndex, clusterId, operationUnitId);
        this.diffs = diffs;
        this.prevLsn = prevLsn;
        assert (prevLsn != null);
    }

    public List<OPageDiff<?>> getChanges() {
        return this.diffs;
    }

    public OLogSequenceNumber getPrevLsn() {
        return this.prevLsn;
    }

    @Override
    public int serializedSize() {
        int serializedSize = super.serializedSize();
        serializedSize += 12;
        serializedSize += 4 + 1 * this.diffs.size();
        for (OPageDiff<?> diff : this.diffs) {
            serializedSize += diff.serializedSize();
        }
        return serializedSize;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.prevLsn.getPosition()), content, offset);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.prevLsn.getSegment()), content, offset += 8);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.diffs.size()), content, offset += 4);
        offset += 4;
        for (OPageDiff<?> diff : this.diffs) {
            content[offset] = this.typeToId(diff.getClass());
            diff.toStream(content, ++offset);
            offset += diff.serializedSize();
        }
        return offset;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        offset = super.fromStream(content, offset);
        long position = OLongSerializer.INSTANCE.deserializeNative(content, offset);
        int segment = OIntegerSerializer.INSTANCE.deserializeNative(content, offset += 8);
        this.prevLsn = new OLogSequenceNumber(segment, position);
        int size = OIntegerSerializer.INSTANCE.deserializeNative(content, offset += 4);
        offset += 4;
        this.diffs = new ArrayList(size);
        int i = 0;
        while (i < size) {
            byte typeId = content[offset];
            OPageDiff<?> diff = this.newDiffInstance(typeId);
            diff.fromStream(content, ++offset);
            offset += diff.serializedSize();
            this.diffs.add(diff);
            ++i;
        }
        return offset;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OUpdatePageRecord that = (OUpdatePageRecord)o;
        if (!this.diffs.equals(that.diffs)) {
            return false;
        }
        return this.prevLsn.equals(that.prevLsn);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.diffs.hashCode();
        result = 31 * result + this.prevLsn.hashCode();
        return result;
    }

    private byte typeToId(Class<? extends OPageDiff> diffClass) {
        if (diffClass.equals(OBinaryPageDiff.class)) {
            return 1;
        }
        if (diffClass.equals(OIntPageDiff.class)) {
            return 2;
        }
        if (diffClass.equals(OLongPageDiff.class)) {
            return 3;
        }
        if (diffClass.equals(OBinaryFullPageDiff.class)) {
            return 4;
        }
        if (diffClass.equals(OIntFullPageDiff.class)) {
            return 5;
        }
        if (diffClass.equals(OLongFullPageDiff.class)) {
            return 6;
        }
        throw new IllegalArgumentException("Unknown Diff class " + diffClass);
    }

    private OPageDiff<?> newDiffInstance(byte typeId) {
        if (typeId == 1) {
            return new OBinaryPageDiff();
        }
        if (typeId == 2) {
            return new OIntPageDiff();
        }
        if (typeId == 3) {
            return new OLongPageDiff();
        }
        if (typeId == 4) {
            return new OBinaryFullPageDiff();
        }
        if (typeId == 5) {
            return new OIntFullPageDiff();
        }
        if (typeId == 6) {
            return new OLongFullPageDiff();
        }
        throw new IllegalArgumentException("Unknown Diff id " + typeId);
    }

    @Override
    public String toString() {
        return "OUpdatePageRecord{ diffs size =" + this.diffs.size() + "} " + super.toString();
    }
}

