/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OFullPageDiff;

public class OLongFullPageDiff
extends OFullPageDiff<Long> {
    public OLongFullPageDiff() {
    }

    public OLongFullPageDiff(Long newValue, int pageOffset, Long oldValue) {
        super(newValue, pageOffset, oldValue);
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16;
    }

    @Override
    public int toStream(byte[] stream, int offset) {
        offset = super.toStream(stream, offset);
        OLongSerializer.INSTANCE.serializeNative((Long)this.oldValue, stream, offset);
        OLongSerializer.INSTANCE.serializeNative((Long)this.newValue, stream, offset += 8);
        return offset += 8;
    }

    @Override
    public int fromStream(byte[] stream, int offset) {
        offset = super.fromStream(stream, offset);
        this.oldValue = OLongSerializer.INSTANCE.deserializeNative(stream, offset);
        this.newValue = OLongSerializer.INSTANCE.deserializeNative(stream, offset += 8);
        return offset += 8;
    }

    @Override
    public void revertPageData(long pagePointer) {
        OLongSerializer.INSTANCE.serializeInDirectMemory((Long)this.oldValue, this.directMemory, pagePointer + (long)this.pageOffset);
    }

    @Override
    public void restorePageData(long pagePointer) {
        OLongSerializer.INSTANCE.serializeInDirectMemory((Long)this.newValue, this.directMemory, pagePointer + (long)this.pageOffset);
    }
}

