/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OFullPageDiff;
import java.util.Arrays;

public class OBinaryFullPageDiff
extends OFullPageDiff<byte[]> {
    public OBinaryFullPageDiff() {
    }

    public OBinaryFullPageDiff(byte[] newValue, int pageOffset, byte[] oldValue) {
        super(newValue, pageOffset, oldValue);
    }

    @Override
    public void revertPageData(long pagePointer) {
        this.directMemory.set(pagePointer + (long)this.pageOffset, (byte[])this.oldValue, 0, ((byte[])this.oldValue).length);
    }

    @Override
    public void restorePageData(long pagePointer) {
        this.directMemory.set(pagePointer + (long)this.pageOffset, (byte[])this.newValue, 0, ((byte[])this.newValue).length);
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8 + ((byte[])this.newValue).length + ((byte[])this.oldValue).length;
    }

    @Override
    public int toStream(byte[] stream, int offset) {
        offset = super.toStream(stream, offset);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(((byte[])this.oldValue).length), stream, offset);
        System.arraycopy(this.oldValue, 0, stream, offset += 4, ((byte[])this.oldValue).length);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(((byte[])this.newValue).length), stream, offset += ((byte[])this.oldValue).length);
        System.arraycopy(this.newValue, 0, stream, offset += 4, ((byte[])this.newValue).length);
        return offset += ((byte[])this.newValue).length;
    }

    @Override
    public int fromStream(byte[] stream, int offset) {
        offset = super.fromStream(stream, offset);
        int oldValueLen = OIntegerSerializer.INSTANCE.deserializeNative(stream, offset);
        this.oldValue = new byte[oldValueLen];
        System.arraycopy(stream, offset += 4, this.oldValue, 0, oldValueLen);
        int newValueLen = OIntegerSerializer.INSTANCE.deserializeNative(stream, offset += oldValueLen);
        this.newValue = new byte[newValueLen];
        System.arraycopy(stream, offset += 4, this.newValue, 0, newValueLen);
        return offset += newValueLen;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBinaryFullPageDiff diff = (OBinaryFullPageDiff)o;
        if (this.pageOffset != diff.pageOffset) {
            return false;
        }
        if (!Arrays.equals((byte[])this.newValue, (byte[])diff.newValue)) {
            return false;
        }
        return Arrays.equals((byte[])this.oldValue, (byte[])diff.oldValue);
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode((byte[])this.newValue);
        result = 31 * result + Arrays.hashCode((byte[])this.oldValue);
        result = 31 * result + this.pageOffset;
        return result;
    }
}

